/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import org.apache.camel.component.netty.http.InboundStreamHttpRequest;
import org.apache.camel.component.netty.http.InboundStreamHttpResponse;

public class HttpInboundStreamHandler
extends MessageToMessageDecoder<HttpObject> {
    private PipedInputStream is;
    private PipedOutputStream os;
    private boolean isChunked;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.os = new PipedOutputStream();
        this.is = new PipedInputStream(this.os);
        this.isChunked = false;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.os.close();
        this.is.close();
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (!super.acceptInboundMessage(msg)) {
            return false;
        }
        if (msg instanceof HttpMessage) {
            HttpHeaders headers = ((HttpMessage)msg).headers();
            this.isChunked = headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED, true);
            return this.isChunked;
        }
        return msg instanceof HttpContent && this.isChunked;
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg instanceof HttpRequest) {
            InboundStreamHttpRequest request = new InboundStreamHttpRequest((HttpRequest)msg, this.is);
            out.add(request);
        }
        if (msg instanceof HttpResponse) {
            InboundStreamHttpResponse response = new InboundStreamHttpResponse((HttpResponse)msg, this.is);
            out.add(response);
        }
        if (msg instanceof HttpContent) {
            ByteBuf body = ((HttpContent)msg).content();
            if (body.readableBytes() > 0) {
                body.readBytes((OutputStream)this.os, body.readableBytes());
            }
            if (msg instanceof LastHttpContent) {
                this.os.close();
            }
        }
    }
}

