/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.cw;

import java.time.Instant;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.cw.Cw2Component;
import org.apache.camel.component.aws2.cw.Cw2Configuration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;

public class Cw2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Cw2Configuration getOrCreateConfiguration(Cw2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Cw2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Cw2Component target = (Cw2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                this.getOrCreateConfiguration(target).setAmazonCwClient((CloudWatchClient)Cw2ComponentConfigurer.property((CamelContext)camelContext, CloudWatchClient.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Cw2Configuration)Cw2ComponentConfigurer.property((CamelContext)camelContext, Cw2Configuration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Cw2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "name": {
                this.getOrCreateConfiguration(target).setName((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Cw2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Cw2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timestamp": {
                this.getOrCreateConfiguration(target).setTimestamp((Instant)Cw2ComponentConfigurer.property((CamelContext)camelContext, Instant.class, (Object)value));
                return true;
            }
            case "unit": {
                this.getOrCreateConfiguration(target).setUnit((String)Cw2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                this.getOrCreateConfiguration(target).setValue((Double)Cw2ComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonCwClient", CloudWatchClient.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", Cw2Configuration.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("name", String.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("timestamp", Instant.class);
        answer.put("unit", String.class);
        answer.put("value", Double.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Cw2Component target = (Cw2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                return this.getOrCreateConfiguration(target).getAmazonCwClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "name": {
                return this.getOrCreateConfiguration(target).getName();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "timestamp": {
                return this.getOrCreateConfiguration(target).getTimestamp();
            }
            case "unit": {
                return this.getOrCreateConfiguration(target).getUnit();
            }
            case "value": {
                return this.getOrCreateConfiguration(target).getValue();
            }
        }
        return null;
    }
}

