/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.resteasy.ResteasyComponent;
import org.apache.camel.component.resteasy.ResteasyConsumer;
import org.apache.camel.component.resteasy.ResteasyHeaderFilterStrategy;
import org.apache.camel.component.resteasy.ResteasyHttpBinding;
import org.apache.camel.component.resteasy.ResteasyProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;

@UriEndpoint(firstVersion="3.4.0", scheme="resteasy", extendsScheme="http", title="Resteasy", syntax="resteasy:httpUri", category={Category.REST})
public class ResteasyEndpoint
extends HttpEndpoint
implements HeaderFilterStrategyAware {
    private String protocol;
    private String host;
    private int port;
    private String uriPattern;
    @UriParam(defaultValue="GET")
    private String resteasyMethod = "GET";
    @UriParam
    private ResteasyHttpBinding restEasyHttpBindingRef;
    @UriParam
    private String servletName;
    @UriParam(label="proxy")
    private String proxyClientClass;
    @UriParam(label="proxy")
    private String proxyMethod;
    @UriParam(label="advanced")
    private Boolean setHttpResponseDuringProcessing = false;
    @UriParam(label="advanced")
    private Boolean skipServletProcessing = false;
    @UriParam(label="security")
    private Boolean basicAuth = false;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new ResteasyHeaderFilterStrategy();

    public ResteasyEndpoint(String endPointURI, ResteasyComponent component, URI httpUri, HttpClientConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (HttpComponent)component, httpUri, HttpClientBuilder.create(), httpConnectionManager, clientConfigurer);
    }

    public Producer createProducer() throws Exception {
        return new ResteasyProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ResteasyConsumer answer = new ResteasyConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public String getProxyMethod() {
        return this.proxyMethod;
    }

    public void setProxyMethod(String proxyMethod) {
        this.proxyMethod = proxyMethod;
    }

    public Boolean getSetHttpResponseDuringProcessing() {
        return this.setHttpResponseDuringProcessing;
    }

    public void setSetHttpResponseDuringProcessing(Boolean setHttpResponseDuringProcessing) {
        this.setHttpResponseDuringProcessing = setHttpResponseDuringProcessing;
    }

    public Boolean getSkipServletProcessing() {
        return this.skipServletProcessing;
    }

    public void setSkipServletProcessing(Boolean skipServletProcessing) {
        this.skipServletProcessing = skipServletProcessing;
    }

    public String getProxyClientClass() {
        return this.proxyClientClass;
    }

    public void setProxyClientClass(String proxyClientClass) {
        this.proxyClientClass = proxyClientClass;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String getResteasyMethod() {
        return this.resteasyMethod;
    }

    public void setResteasyMethod(String resteasyMethod) {
        this.resteasyMethod = resteasyMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public Boolean getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(Boolean basicAuth) {
        this.basicAuth = basicAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ResteasyHttpBinding getRestEasyHttpBindingRef() {
        return this.restEasyHttpBindingRef;
    }

    public void setRestEasyHttpBindingRef(ResteasyHttpBinding restEasyHttpBinding) {
        this.restEasyHttpBindingRef = restEasyHttpBinding;
    }
}

