/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.Optional;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;

public final class ZooKeeperCuratorHelper {
    private ZooKeeperCuratorHelper() {
    }

    public static CuratorFramework createCurator(ZooKeeperCuratorConfiguration configuration) throws Exception {
        CuratorFramework curator = configuration.getCuratorFramework();
        if (curator == null) {
            ObjectHelper.notNull(configuration.getNodes(), (String)"ZooKeeper Nodes");
            RetryPolicy retryPolicy = configuration.getRetryPolicy();
            if (retryPolicy == null) {
                retryPolicy = new ExponentialBackoffRetry((int)configuration.getReconnectBaseSleepTimeUnit().toMillis(configuration.getReconnectBaseSleepTime()), configuration.getReconnectMaxRetries(), (int)configuration.getReconnectMaxSleepTimeUnit().toMillis(configuration.getReconnectMaxSleepTime()));
            }
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(String.join((CharSequence)",", configuration.getNodes())).sessionTimeoutMs((int)configuration.getSessionTimeoutUnit().toMillis(configuration.getSessionTimeout())).connectionTimeoutMs((int)configuration.getConnectionTimeoutUnit().toMillis(configuration.getConnectionTimeout())).maxCloseWaitMs((int)configuration.getMaxCloseWaitUnit().toMillis(configuration.getMaxCloseWait())).retryPolicy(retryPolicy);
            Optional.ofNullable(configuration.getNamespace()).ifPresent(arg_0 -> ((CuratorFrameworkFactory.Builder)builder).namespace(arg_0));
            Optional.ofNullable(configuration.getAuthInfoList()).ifPresent(arg_0 -> ((CuratorFrameworkFactory.Builder)builder).authorization(arg_0));
            curator = builder.build();
        }
        return curator;
    }

    public static <T> ServiceDiscovery<T> createServiceDiscovery(ZooKeeperCuratorConfiguration configuration, CuratorFramework curator, Class<T> payloadType) {
        return ServiceDiscoveryBuilder.builder(payloadType).client(curator).basePath(configuration.getBasePath()).serializer((InstanceSerializer)new JsonInstanceSerializer(payloadType)).build();
    }
}

