/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Script;
import java.util.Map;
import org.apache.camel.Service;
import org.apache.camel.language.groovy.GroovyExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.LanguageSupport;
import org.codehaus.groovy.runtime.InvokerHelper;

@Language(value="groovy")
public class GroovyLanguage
extends LanguageSupport {
    private final Map<String, GroovyClassService> scriptCache = LRUCacheFactory.newLRUSoftCache((int)16, (int)1000, (boolean)true);

    public static GroovyExpression groovy(String expression) {
        return new GroovyLanguage().createExpression(expression);
    }

    public GroovyExpression createPredicate(String expression) {
        return this.createExpression(expression);
    }

    public GroovyExpression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new GroovyExpression(expression);
    }

    Class<Script> getScriptFromCache(String script) {
        GroovyClassService cached = this.scriptCache.get(script);
        if (cached == null) {
            return null;
        }
        return cached.script;
    }

    void addScriptToCache(String script, Class<Script> scriptClass) {
        this.scriptCache.put(script, new GroovyClassService(scriptClass));
    }

    private static final class GroovyClassService
    implements Service {
        private final Class<Script> script;

        private GroovyClassService(Class<Script> script) {
            this.script = script;
        }

        public void start() {
        }

        public void stop() {
            InvokerHelper.removeClass(this.script);
        }
    }
}

