/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.builder.ExpressionBuilder;

public class CompositeNodes
extends BaseSimpleNode {
    private final List<SimpleNode> children = new ArrayList<SimpleNode>();

    public CompositeNodes(SimpleToken token) {
        super(token);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SimpleNode child : this.children) {
            sb.append(child.toString());
        }
        return sb.toString();
    }

    public void addChild(SimpleNode child) {
        this.children.add(child);
    }

    public List<SimpleNode> getChildren() {
        return this.children;
    }

    @Override
    public Expression createExpression(String expression) {
        if (this.children.isEmpty()) {
            return null;
        }
        if (this.children.size() == 1) {
            return this.children.get(0).createExpression(expression);
        }
        ArrayList<Expression> answer = new ArrayList<Expression>();
        for (SimpleNode child : this.children) {
            answer.add(child.createExpression(expression));
        }
        return ExpressionBuilder.concatExpression(answer);
    }
}

