/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.composite.ReferenceId;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatch;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatchResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectComposite;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectCompositeResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTree;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTreeResponse;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.client.CompositeApiClient;
import org.apache.camel.component.salesforce.internal.client.DefaultCompositeApiClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.support.service.ServiceHelper;

public final class CompositeApiProcessor
extends AbstractSalesforceProcessor {
    private CompositeApiClient compositeClient;
    private PayloadFormat format;

    public CompositeApiProcessor(SalesforceEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SalesforceEndpointConfig configuration = this.endpoint.getConfiguration();
        String apiVersion = configuration.getApiVersion();
        this.format = configuration.getFormat();
        if (!EnumSet.of(PayloadFormat.JSON, PayloadFormat.XML).contains((Object)this.format)) {
            throw new SalesforceException("Unsupported format: " + (Object)((Object)this.format), 0);
        }
        this.compositeClient = new DefaultCompositeApiClient(configuration, this.format, apiVersion, this.session, this.httpClient, this.loginConfig);
        ServiceHelper.startService((Object)this.compositeClient);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.compositeClient);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            switch (this.operationName) {
                case COMPOSITE_TREE: {
                    return this.processInternal(SObjectTree.class, exchange, this.compositeClient::submitCompositeTree, this::processCompositeTreeResponse, callback);
                }
                case COMPOSITE_BATCH: {
                    return this.processInternal(SObjectBatch.class, exchange, this.compositeClient::submitCompositeBatch, this::processCompositeBatchResponse, callback);
                }
                case COMPOSITE: {
                    return this.processInternal(SObjectComposite.class, exchange, this.compositeClient::submitComposite, this::processCompositeResponse, callback);
                }
            }
            throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
        }
        catch (SalesforceException e) {
            return CompositeApiProcessor.processException(exchange, callback, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            SalesforceException exception = new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e);
            return CompositeApiProcessor.processException(exchange, callback, (Exception)((Object)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompositeBatchResponse(Exchange exchange, Optional<SObjectBatchResponse> responseBody, Map<String, String> headers, SalesforceException exception, AsyncCallback callback) {
        try {
            if (!responseBody.isPresent()) {
                exchange.setException((Throwable)((Object)exception));
            } else {
                Message in = exchange.getIn();
                Message out = exchange.getOut();
                SObjectBatchResponse response = responseBody.get();
                out.copyFromWithNewBody(in, (Object)response);
                out.getHeaders().putAll(headers);
            }
        }
        finally {
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompositeResponse(Exchange exchange, Optional<SObjectCompositeResponse> responseBody, Map<String, String> headers, SalesforceException exception, AsyncCallback callback) {
        try {
            if (!responseBody.isPresent()) {
                exchange.setException((Throwable)((Object)exception));
            } else {
                Message in = exchange.getIn();
                Message out = exchange.getOut();
                SObjectCompositeResponse response = responseBody.get();
                out.copyFromWithNewBody(in, (Object)response);
                out.getHeaders().putAll(headers);
            }
        }
        finally {
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompositeTreeResponse(Exchange exchange, Optional<SObjectTreeResponse> responseBody, Map<String, String> headers, SalesforceException exception, AsyncCallback callback) {
        try {
            if (!responseBody.isPresent()) {
                exchange.setException((Throwable)((Object)exception));
            } else {
                Message in = exchange.getIn();
                Message out = exchange.getOut();
                SObjectTree tree = (SObjectTree)in.getBody(SObjectTree.class);
                SObjectTreeResponse response = responseBody.get();
                boolean hasErrors = response.hasErrors();
                for (ReferenceId referenceId : response.getResults()) {
                    tree.setIdFor(referenceId.getReferenceId(), referenceId.getId());
                    if (!hasErrors) continue;
                    tree.setErrorFor(referenceId.getReferenceId(), referenceId.getErrors());
                }
                if (hasErrors) {
                    SalesforceException withErrors = new SalesforceException(response.getAllErrors(), exception.getStatusCode(), (Throwable)((Object)exception));
                    exchange.setException((Throwable)((Object)withErrors));
                }
                out.copyFromWithNewBody(in, (Object)tree);
                out.getHeaders().putAll(headers);
            }
        }
        finally {
            callback.done(false);
        }
    }

    <T, R> boolean processInternal(Class<T> bodyType, Exchange exchange, CompositeApiClient.Operation<T, R> clientOperation, ResponseHandler<R> responseHandler, AsyncCallback callback) throws SalesforceException {
        Object body;
        Message in = exchange.getIn();
        try {
            body = in.getMandatoryBody(bodyType);
        }
        catch (InvalidPayloadException e) {
            throw new SalesforceException(e);
        }
        clientOperation.submit(body, this.determineHeaders(exchange), (response, responseHeaders, exception) -> responseHandler.handleResponse(exchange, response, responseHeaders, exception, callback));
        return false;
    }

    static boolean processException(Exchange exchange, AsyncCallback callback, Exception e) {
        exchange.setException((Throwable)e);
        callback.done(true);
        return true;
    }

    @FunctionalInterface
    static interface ResponseHandler<T> {
        public void handleResponse(Exchange var1, Optional<T> var2, Map<String, String> var3, SalesforceException var4, AsyncCallback var5);
    }
}

