/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponentVerifierExtension;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

@Component(value="aws2-ddbstream")
public class Ddb2StreamComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Ddb2StreamComponent.class);
    @Metadata
    private Ddb2StreamConfiguration configuration = new Ddb2StreamConfiguration();

    public Ddb2StreamComponent() {
        this(null);
    }

    public Ddb2StreamComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Ddb2StreamComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        Ddb2StreamConfiguration configuration = this.configuration != null ? this.configuration.copy() : new Ddb2StreamConfiguration();
        configuration.setTableName(remaining);
        Ddb2StreamEndpoint endpoint = new Ddb2StreamEndpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getAmazonDynamoDbStreamsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonDDBStreamsClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Ddb2StreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Ddb2StreamConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Ddb2StreamConfiguration configuration, Ddb2StreamEndpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonDynamoDbStreamsClient())) {
            LOG.debug("Looking for an DynamoDbStreamsClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(DynamoDbStreamsClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one DynamoDbStreamsClient instance in the registry");
                configuration.setAmazonDynamoDbStreamsClient((DynamoDbStreamsClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No DynamoDbStreamsClient instance in the registry");
            }
        } else {
            LOG.debug("DynamoDbStreamsClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

