/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.thrift.ThriftConfiguration;
import org.apache.camel.component.thrift.ThriftEndpoint;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

@Component(value="thrift")
public class ThriftComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ThriftConfiguration config = new ThriftConfiguration();
        config = this.parseConfiguration(config, uri, parameters);
        SSLContextParameters sslParameters = config.getSslParameters();
        if (config.getNegotiationType() == ThriftNegotiationType.SSL && sslParameters == null) {
            sslParameters = this.retrieveGlobalSslContextParameters();
            config.setSslParameters(sslParameters);
        }
        ThriftEndpoint endpoint = new ThriftEndpoint(uri, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected ThriftConfiguration parseConfiguration(ThriftConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(new URI(remaining), parameters, this);
        return configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

