/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.util.Objects;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.iec60870.AbstractConnectionMultiplexor;
import org.apache.camel.component.iec60870.AbstractIecEndpoint;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.server.ServerConnectionMultiplexor;
import org.apache.camel.component.iec60870.server.ServerConsumer;
import org.apache.camel.component.iec60870.server.ServerProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultComponent;

@UriEndpoint(firstVersion="2.20.0", scheme="iec60870-server", syntax="iec60870-server:uriPath", title="IEC 60870 Server", category={Category.IOT})
public class ServerEndpoint
extends AbstractIecEndpoint<ServerConnectionMultiplexor> {
    @UriParam(defaultValue="true")
    private boolean filterNonExecute = true;

    public ServerEndpoint(String uri, DefaultComponent component, ServerConnectionMultiplexor connection, ObjectAddress address) {
        super(uri, component, (AbstractConnectionMultiplexor)Objects.requireNonNull(connection), address);
    }

    public Producer createProducer() throws Exception {
        return new ServerProducer(this, ((ServerConnectionMultiplexor)this.getConnection()).getServer());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ServerConsumer(this, processor, ((ServerConnectionMultiplexor)this.getConnection()).getServer());
    }

    public void setFilterNonExecute(boolean filterNonExecute) {
        this.filterNonExecute = filterNonExecute;
    }

    public boolean isFilterNonExecute() {
        return this.filterNonExecute;
    }
}

