/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy.servlet;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.resteasy.ResteasyComponent;
import org.apache.camel.component.resteasy.ResteasyEndpoint;
import org.apache.camel.component.resteasy.servlet.ResteasyHttpServletRequestWrapper;
import org.apache.camel.component.resteasy.servlet.ResteasyHttpServletResponseWrapper;
import org.apache.camel.component.resteasy.servlet.ResteasyInvocationHandler;
import org.apache.camel.http.common.DefaultHttpRegistry;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.http.common.HttpRegistryProvider;
import org.apache.camel.support.DefaultExchange;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResteasyCamelServlet
extends HttpServletDispatcher
implements HttpRegistryProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ResteasyCamelServlet.class);
    private HttpRegistry httpRegistry;
    private String servletName;
    private final ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap<String, HttpConsumer>();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String name = servletConfig.getServletName();
        if (this.httpRegistry == null) {
            this.httpRegistry = DefaultHttpRegistry.getHttpRegistry((String)name);
            HttpRegistryProvider existing = this.httpRegistry.getCamelServlet(name);
            if (existing != null) {
                LOG.info("Duplicate ServletName detected: {}. Existing: {} This: {}. Its advised to use unique ServletName per Camel application.", new Object[]{name, existing, ((Object)((Object)this)).toString()});
            }
            this.httpRegistry.register((HttpRegistryProvider)this);
        }
        for (Map.Entry entry : this.consumers.entrySet()) {
            String proxyClasses = ((ResteasyComponent)this.getServletEndpoint((HttpConsumer)entry.getValue()).getComponent()).getProxyConsumersClasses();
            if (proxyClasses == null) continue;
            String[] classes = proxyClasses.split(",");
            LOG.debug("Proxy classes defined in the component {}", Arrays.asList(classes));
            for (String clazz : classes) {
                try {
                    Class<?> realClazz = Class.forName(clazz);
                    ResteasyInvocationHandler handler = new ResteasyInvocationHandler();
                    Object proxy = Proxy.newProxyInstance(realClazz.getClassLoader(), new Class[]{realClazz}, (InvocationHandler)handler);
                    this.getDispatcher().getRegistry().addSingletonResource(proxy);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Error initializing servlet: {}", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
            return;
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpMessage m;
        HttpConsumer consumer;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Service: {}", (Object)httpServletRequest);
        }
        if ((consumer = this.resolve(httpServletRequest)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No consumer to service request {}", (Object)httpServletRequest);
            }
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        if (consumer.isSuspended()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Consumer suspended, cannot service request {}", (Object)httpServletRequest);
            }
            httpServletResponse.sendError(503);
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        if ("OPTIONS".equals(httpServletRequest.getMethod())) {
            String s = consumer.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS," + consumer.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            httpServletResponse.addHeader("Allow", s);
            httpServletResponse.setStatus(200);
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        if ("TRACE".equals(httpServletRequest.getMethod()) && !consumer.isTraceEnabled()) {
            httpServletResponse.sendError(405);
            super.service(httpServletRequest, httpServletResponse);
            return;
        }
        DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
        if (consumer.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
        }
        if (consumer.getEndpoint().isDisableStreamCache()) {
            exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
        }
        if (this.getServletEndpoint(consumer).getSkipServletProcessing().booleanValue()) {
            if (this.getServletEndpoint(consumer).getHttpMethodRestrict() != null && !httpServletRequest.getMethod().equals(this.getServletEndpoint(consumer).getHttpMethodRestrict())) {
                httpServletResponse.setStatus(405);
                return;
            }
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
        String response = "";
        if (this.getServletEndpoint(consumer).getSetHttpResponseDuringProcessing().booleanValue() || this.getServletEndpoint(consumer).getSkipServletProcessing().booleanValue()) {
            if (httpServletResponse.getStatus() != 200 && httpServletResponse.getStatus() != 204) {
                return;
            }
            HttpHelper.setCharsetFromContentType((String)httpServletRequest.getContentType(), (Exchange)exchange);
            m = new HttpMessage((Exchange)exchange, consumer.getEndpoint(), httpServletRequest, httpServletResponse);
            m.setBody((Object)((ResteasyHttpServletRequestWrapper)httpServletRequest).getStream());
            exchange.setIn((Message)m);
        } else {
            if (httpServletResponse.getStatus() != 200) {
                return;
            }
            HttpHelper.setCharsetFromContentType((String)httpServletRequest.getContentType(), (Exchange)exchange);
            m = new HttpMessage((Exchange)exchange, consumer.getEndpoint(), httpServletRequest, httpServletResponse);
            response = new String(((ResteasyHttpServletResponseWrapper)httpServletResponse).getCopy(), httpServletResponse.getCharacterEncoding());
            m.setBody((Object)((ResteasyHttpServletResponseWrapper)httpServletResponse).getStream());
            exchange.setIn((Message)m);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copier service: {}", (Object)new String(((ResteasyHttpServletResponseWrapper)httpServletResponse).getCopy(), httpServletResponse.getCharacterEncoding()));
        }
        String contextPath = consumer.getEndpoint().getPath();
        exchange.getIn().setHeader("CamelResteasyContextPath", (Object)contextPath);
        exchange.getIn().setHeader("CamelResteasyHttpRequest", (Object)httpServletRequest);
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        if (contextPath != null && httpPath.startsWith(contextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(contextPath.length()));
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            consumer.getProcessor().process((Exchange)exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing response for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            if (!response.isEmpty()) {
                httpServletResponse.resetBuffer();
            }
            consumer.getBinding().writeResponse((Exchange)exchange, httpServletResponse);
        }
        catch (IOException e) {
            LOG.error("Error processing request: {}", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error processing request: {}", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void connect(HttpConsumer consumer) {
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void destroy() {
        DefaultHttpRegistry.removeHttpRegistry((String)this.getServletName());
        if (this.httpRegistry != null) {
            this.httpRegistry.unregister((HttpRegistryProvider)this);
            this.httpRegistry = null;
        }
        LOG.info("Destroyed CamelResteasyServlet[{}]", (Object)this.getServletName());
    }

    public void disconnect(HttpConsumer consumer) {
        LOG.info("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getPath());
    }

    protected ResteasyEndpoint getServletEndpoint(HttpConsumer consumer) {
        if (!(consumer.getEndpoint() instanceof ResteasyEndpoint)) {
            throw new RuntimeException("Invalid consumer type. Must be RESTEasyEndpoint but is " + consumer.getClass().getName());
        }
        return (ResteasyEndpoint)consumer.getEndpoint();
    }

    protected HttpConsumer resolve(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        HttpConsumer answer = (HttpConsumer)this.consumers.get(path);
        if (answer == null) {
            for (String key : this.consumers.keySet()) {
                if (!((HttpConsumer)this.consumers.get(key)).getEndpoint().isMatchOnUriPrefix() || !path.startsWith(key)) continue;
                answer = (HttpConsumer)this.consumers.get(key);
                break;
            }
        }
        return answer;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public Map<String, HttpConsumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }
}

