/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.component.workday.auth.AuthClientForIntegration;
import org.apache.camel.component.workday.auth.AutheticationClient;
import org.apache.camel.support.DefaultProducer;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkdayReportProducer
extends DefaultProducer {
    public static final String WORKDAY_URL_HEADER = "CamelWorkdayURL";
    public static final String WORKDAY_RASS_URL_TEMPALTE = "https://%s/ccx/service/customreport2/%s%s";
    private static final Logger LOG = LoggerFactory.getLogger(WorkdayReportProducer.class);
    private WorkdayEndpoint endpoint;
    private AutheticationClient autheticationClient;

    public WorkdayReportProducer(WorkdayEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.autheticationClient = new AuthClientForIntegration(this.endpoint.getWorkdayConfiguration());
    }

    public WorkdayEndpoint getEndpoint() {
        return (WorkdayEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PoolingHttpClientConnectionManager httpClientConnectionManager = this.endpoint.getWorkdayConfiguration().getHttpConnectionManager();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        String workdayUri = this.prepareUri(this.endpoint.getWorkdayConfiguration());
        HttpGet httpGet = new HttpGet(workdayUri);
        this.autheticationClient.configure(httpClient, (HttpRequestBase)httpGet);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new IllegalStateException("Got the invalid http status value '" + httpResponse.getStatusLine() + "' as the result of the RAAS '" + workdayUri + "'");
        }
        String report = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)httpResponse.getEntity().getContent());
        if (report.isEmpty()) {
            throw new IllegalStateException("Got the unexpected value '" + report + "' as the result of the report '" + workdayUri + "'");
        }
        exchange.getIn().setBody((Object)report);
        exchange.getIn().setHeader(WORKDAY_URL_HEADER, (Object)workdayUri);
    }

    public String prepareUri(WorkdayConfiguration configuration) {
        Map<String, Object> parameters = configuration.getParameters();
        StringBuilder stringBuilder = new StringBuilder(configuration.getPath());
        stringBuilder.append("?");
        if (parameters.size() > 0) {
            String params = parameters.keySet().stream().map(k -> k + "=" + parameters.get(k)).collect(Collectors.joining("&"));
            stringBuilder.append(params);
            stringBuilder.append("&");
        }
        stringBuilder.append("format=");
        stringBuilder.append(configuration.getReportFormat());
        String uriString = String.format(WORKDAY_RASS_URL_TEMPALTE, configuration.getHost(), configuration.getTenant(), stringBuilder.toString());
        return uriString;
    }
}

