/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Status;
import twitter4j.StatusUpdate;

public class UserProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(UserProducer.class);
    private TwitterEndpoint endpoint;

    public UserProducer(TwitterEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Status response;
        Object in = exchange.getIn().getBody();
        if (in instanceof StatusUpdate) {
            response = this.updateStatus((StatusUpdate)in);
        } else {
            String s = (String)exchange.getIn().getMandatoryBody(String.class);
            response = this.updateStatus(s);
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)response);
        }
    }

    private Status updateStatus(StatusUpdate status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().updateStatus(status);
        LOG.debug("Updated status: {}", (Object)status);
        LOG.debug("Status id: {}", (Object)response.getId());
        return response;
    }

    private Status updateStatus(String status) throws Exception {
        Status response = this.endpoint.getProperties().getTwitter().updateStatus(status);
        LOG.debug("Updated status: {}", (Object)status);
        LOG.debug("Status id: {}", (Object)response.getId());
        return response;
    }
}

