/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.camel.processor.lucene.support.Hit;
import org.apache.camel.processor.lucene.support.Hits;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearcher {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSearcher.class);
    private Analyzer analyzer;
    private IndexSearcher indexSearcher;
    private IndexReader indexReader;
    private ScoreDoc[] hits;

    public void open(File indexDirectory, Analyzer analyzer) throws IOException {
        this.indexReader = indexDirectory != null ? DirectoryReader.open((Directory)new NIOFSDirectory(indexDirectory.toPath())) : DirectoryReader.open((Directory)new NIOFSDirectory(new File("./indexDirectory").toPath()));
        this.indexSearcher = new IndexSearcher(this.indexReader);
        this.analyzer = analyzer;
    }

    public void close() throws IOException {
        this.indexReader.close();
        this.analyzer.close();
    }

    public Hits search(String searchPhrase, int maxNumberOfHits, int totalHitsThreshold) throws Exception {
        return this.search(searchPhrase, maxNumberOfHits, totalHitsThreshold, false);
    }

    public Hits search(String searchPhrase, int maxNumberOfHits, int totalHitsThreshold, boolean returnLuceneDocs) throws Exception {
        Hits searchHits = new Hits();
        int numberOfHits = this.doSearch(searchPhrase, maxNumberOfHits, totalHitsThreshold);
        searchHits.setNumberOfHits(numberOfHits);
        for (ScoreDoc hit : this.hits) {
            Document selectedDocument = this.indexSearcher.doc(hit.doc);
            Hit aHit = new Hit();
            if (returnLuceneDocs) {
                aHit.setDocument(selectedDocument);
            }
            aHit.setHitLocation(hit.doc);
            aHit.setScore(hit.score);
            aHit.setData(selectedDocument.get("contents"));
            searchHits.getHit().add(aHit);
        }
        return searchHits;
    }

    private int doSearch(String searchPhrase, int maxNumberOfHits, int totalHitsThreshold) throws NullPointerException, ParseException, IOException {
        LOG.trace("*** Search Phrase: {} ***", (Object)searchPhrase);
        QueryParser parser = new QueryParser("contents", this.analyzer);
        Query query = parser.parse(searchPhrase);
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)maxNumberOfHits, (int)totalHitsThreshold);
        this.indexSearcher.search(query, (Collector)collector);
        this.hits = collector.topDocs().scoreDocs;
        LOG.trace("*** Search generated {} hits ***", (Object)this.hits.length);
        return this.hits.length;
    }
}

