/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.git.GitComponent;
import org.apache.camel.component.git.consumer.GitBranchConsumer;
import org.apache.camel.component.git.consumer.GitCommitConsumer;
import org.apache.camel.component.git.consumer.GitTagConsumer;
import org.apache.camel.component.git.consumer.GitType;
import org.apache.camel.component.git.producer.GitProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.16.0", scheme="git", title="Git", syntax="git:localPath", category={Category.FILE})
public class GitEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String localPath;
    @UriParam
    private String branchName;
    @UriParam
    private String tagName;
    @UriParam(enums="commit,tag,branch", label="consumer")
    private GitType type;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private String remotePath;
    @UriParam
    private String remoteName;
    @UriParam(defaultValue="true")
    @Metadata(label="producer")
    private boolean allowEmpty = true;
    @UriParam(enums="clone,init,add,remove,commit,commitAll,createBranch,deleteBranch,createTag,deleteTag,status,log,push,pull,showBranches,cherryPick,remoteAdd,remoteList", label="producer")
    private String operation;

    public GitEndpoint(String uri, GitComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new GitProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.type == GitType.COMMIT) {
            return new GitCommitConsumer(this, processor);
        }
        if (this.type == GitType.TAG) {
            return new GitTagConsumer(this, processor);
        }
        if (this.type == GitType.BRANCH) {
            return new GitBranchConsumer(this, processor);
        }
        throw new IllegalArgumentException("Cannot create consumer with type " + (Object)((Object)this.type));
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public GitType getType() {
        return this.type;
    }

    public void setType(GitType type) {
        this.type = type;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

