/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.cms.common.CryptoCmsMarshallerConfiguration;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.sig.SignerInfo;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class SignedDataCreatorConfiguration
extends CryptoCmsMarshallerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDataCreatorConfiguration.class);
    @UriParam(label="sign", defaultValue="true")
    private Boolean includeContent = Boolean.TRUE;
    @UriParam(label="sign", javaType="java.lang.String", description="Signer information: reference to bean(s) which implements org.apache.camel.component.crypto.cms.api.SignerInfo. Multiple values can be separated by comma")
    private List<SignerInfo> signer = new ArrayList<SignerInfo>();

    public SignedDataCreatorConfiguration(CamelContext context) {
        super(context);
    }

    public Boolean getIncludeContent() {
        return this.includeContent;
    }

    public void setIncludeContent(Boolean includeContent) {
        this.includeContent = includeContent;
    }

    public List<SignerInfo> getSigner() {
        return this.signer;
    }

    public void setSigner(List<SignerInfo> signer) {
        this.signer = signer;
    }

    public void setSigner(String signer) {
        String[] values;
        for (String s : values = signer.split(",")) {
            SignerInfo obj;
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (this.getContext() == null || (obj = (SignerInfo)this.getContext().getRegistry().lookupByNameAndType(s, SignerInfo.class)) == null) continue;
            this.addSigner(obj);
        }
    }

    public void addSigner(SignerInfo info) {
        if (this.signer == null) {
            this.signer = new ArrayList<SignerInfo>();
        }
        this.signer.add(info);
    }

    public void init() throws CryptoCmsException {
        if (this.signer.isEmpty()) {
            this.logErrorAndThrow(LOG, "No signer set.");
        }
    }
}

