/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;

public class WatcherProducer
extends DefaultProducer {
    public WatcherProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        boolean hasWatchersToRemove;
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        List watchersAdd = (List)exchange.getIn().getHeader("IssueWatchersAdd", List.class);
        List watchersRemove = (List)exchange.getIn().getHeader("IssueWatchersRemove", List.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key to add/remove watchers to.");
        }
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        boolean hasWatchersToAdd = watchersAdd != null && watchersAdd.size() > 0;
        boolean bl = hasWatchersToRemove = watchersRemove != null && watchersRemove.size() > 0;
        if (hasWatchersToAdd || hasWatchersToRemove) {
            IssueRestClient issueClient = client.getIssueClient();
            Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
            if (hasWatchersToAdd) {
                for (String watcher : watchersAdd) {
                    issueClient.addWatcher(issue.getWatchers().getSelf(), watcher);
                }
            }
            if (hasWatchersToRemove) {
                for (String watcher : watchersRemove) {
                    issueClient.removeWatcher(issue.getWatchers().getSelf(), watcher);
                }
            }
        }
    }
}

