/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.util.LinkedList;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointEventListener
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointEventListener.class);
    private final JcrEndpoint endpoint;
    private final Processor processor;

    public EndpointEventListener(JcrEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public void onEvent(EventIterator events) {
        LOG.trace("onEvent START");
        LOG.debug("{} consumer received JCR events: {}", (Object)this.endpoint, (Object)events);
        RuntimeCamelException rce = null;
        try {
            Exchange exchange = this.createExchange(events);
            try {
                LOG.debug("Processor, {}, is processing exchange, {}", (Object)this.processor, (Object)exchange);
                this.processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            rce = (RuntimeCamelException)exchange.getException(RuntimeCamelException.class);
        }
        catch (Exception e) {
            rce = RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (rce != null) {
            LOG.trace("onEvent END throwing exception: {}", (Object)rce.toString());
            throw rce;
        }
        LOG.trace("onEvent END");
    }

    private Exchange createExchange(EventIterator events) {
        Exchange exchange = this.endpoint.createExchange();
        LinkedList<Event> eventList = new LinkedList<Event>();
        if (events != null) {
            while (events.hasNext()) {
                eventList.add(events.nextEvent());
            }
        }
        exchange.getIn().setBody(eventList);
        return exchange;
    }
}

