/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Gauge;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.spi.CamelEvent;

public class MicrometerRouteEventNotifier
extends AbstractMicrometerEventNotifier<CamelEvent.RouteEvent> {
    private final AtomicLong routesAdded = new AtomicLong();
    private final AtomicLong routesRunning = new AtomicLong();
    private MicrometerRouteEventNotifierNamingStrategy namingStrategy = MicrometerRouteEventNotifierNamingStrategy.DEFAULT;

    public MicrometerRouteEventNotifier() {
        super(CamelEvent.RouteEvent.class);
    }

    public MicrometerRouteEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Gauge.builder((String)this.namingStrategy.getRouteAddedName(), (Object)this.routesAdded, value -> Long.valueOf(value.get()).doubleValue()).baseUnit("routes").tags((Iterable)this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
        Gauge.builder((String)this.namingStrategy.getRouteRunningName(), (Object)this.routesRunning, value -> Long.valueOf(value.get()).doubleValue()).baseUnit("routes").tags((Iterable)this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
    }

    public void notify(CamelEvent eventObject) {
        if (eventObject instanceof CamelEvent.RouteAddedEvent) {
            this.routesAdded.incrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteRemovedEvent) {
            this.routesAdded.decrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteStartedEvent) {
            this.routesRunning.incrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteStoppedEvent) {
            this.routesRunning.decrementAndGet();
        }
    }
}

