/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.MDC;

public class RouteService
extends ChildServiceSupport {
    private final CamelContext camelContext;
    private final Route route;
    private boolean removingRoutes;
    private final Map<Route, Consumer> inputs = new HashMap<Route, Consumer>();
    private final AtomicBoolean warmUpDone = new AtomicBoolean(false);
    private final AtomicBoolean endpointDone = new AtomicBoolean(false);

    public RouteService(Route route) {
        this.route = route;
        this.camelContext = this.route.getCamelContext();
    }

    public String getId() {
        return this.route.getId();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Route getRoute() {
        return this.route;
    }

    public Set<Endpoint> gatherEndpoints() {
        LinkedHashSet<Endpoint> answer = new LinkedHashSet<Endpoint>();
        Set<Service> services = this.gatherChildServices();
        for (Service service : services) {
            Endpoint endpoint;
            if (!(service instanceof EndpointAware) || (endpoint = ((EndpointAware)service).getEndpoint()) == null) continue;
            answer.add(endpoint);
        }
        return answer;
    }

    public Map<Route, Consumer> getInputs() {
        return this.inputs;
    }

    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public void warmUp() throws FailedToStartRouteException {
        try {
            this.doWarmUp();
        }
        catch (Exception e) {
            throw new FailedToStartRouteException(this.getId(), this.route.getDescription(), (Throwable)e);
        }
    }

    public boolean isAutoStartup() {
        if (!this.getCamelContext().isAutoStartup().booleanValue()) {
            return false;
        }
        return this.getRoute().isAutoStartup();
    }

    protected synchronized void doWarmUp() throws Exception {
        if (this.endpointDone.compareAndSet(false, true)) {
            ServiceHelper.startService((Object)this.route.getEndpoint());
        }
        if (this.warmUpDone.compareAndSet(false, true)) {
            try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
                this.route.warmUp();
                List services = this.route.getServices();
                this.route.onStartingServices(services);
                LinkedHashSet list = new LinkedHashSet();
                for (Service service : services) {
                    list.addAll(ServiceHelper.getChildServices((Service)service));
                }
                ArrayList<Service> childServices = new ArrayList<Service>();
                for (Service service : list) {
                    if (service instanceof RouteAware) {
                        ((RouteAware)service).setRoute(this.route);
                    }
                    if (service instanceof RouteIdAware) {
                        ((RouteIdAware)service).setRouteId(this.route.getId());
                    }
                    if (service instanceof CamelContextAware) {
                        ((CamelContextAware)service).setCamelContext(this.camelContext);
                    }
                    if (service instanceof Consumer) {
                        this.inputs.put(this.route, (Consumer)service);
                        continue;
                    }
                    childServices.add(service);
                }
                this.startChildService(this.route, childServices);
                EventHelper.notifyRouteAdded((CamelContext)this.camelContext, (Route)this.route);
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesAdd(Collections.singletonList(this.route));
            }
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).addRoute(this.route);
            this.camelContext.getInflightRepository().addRoute(this.route.getId());
        }
    }

    protected void doStart() {
        try {
            this.warmUp();
        }
        catch (FailedToStartRouteException e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            ServiceHelper.startService((Object)this.route);
            this.routePolicyCallback(RoutePolicy::onStart);
            EventHelper.notifyRouteStarted((CamelContext)this.camelContext, (Route)this.route);
        }
    }

    protected void doStop() {
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(Collections.singletonList(this.route));
            }
        }
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildService(this.route, services, isShutdownCamelContext);
            if (isShutdownCamelContext) {
                ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route});
            } else {
                ServiceHelper.stopService((Object)this.route);
            }
            this.routePolicyCallback(RoutePolicy::onStop);
            EventHelper.notifyRouteStopped((CamelContext)this.camelContext, (Route)this.route);
        }
        if (this.isRemovingRoutes()) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).removeRoute(this.route);
        }
        this.warmUpDone.set(false);
    }

    protected void doShutdown() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildService(this.route, services, true);
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route});
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.route.getEndpoint()});
            this.routePolicyCallback(RoutePolicy::onRemove);
            EventHelper.notifyRouteRemoved((CamelContext)this.camelContext, (Route)this.route);
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(Collections.singletonList(this.route));
        }
        this.camelContext.getInflightRepository().removeRoute(this.route.getId());
        ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).removeRoute(this.route);
        this.inputs.clear();
        this.warmUpDone.set(false);
        this.endpointDone.set(false);
    }

    protected void doSuspend() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onSuspend);
        }
    }

    protected void doResume() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onResume);
        }
    }

    private void routePolicyCallback(BiConsumer<RoutePolicy, Route> callback) {
        if (this.route.getRoutePolicyList() != null) {
            for (RoutePolicy routePolicy : this.route.getRoutePolicyList()) {
                callback.accept(routePolicy, this.route);
            }
        }
    }

    protected void startChildService(Route route, List<Service> services) {
        for (Service service : services) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd(this.camelContext, service, route);
            }
            ServiceHelper.startService((Object)service);
            this.addChildService(service);
        }
    }

    protected void stopChildService(Route route, Set<Service> services, boolean shutdown) {
        for (Service service : services) {
            if (service instanceof ErrorHandler) {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    ErrorHandlerFactory errorHandlerFactory = route.getErrorHandlerFactory();
                    strategy.onErrorHandlerRemove(route, (Processor)service, errorHandlerFactory);
                }
            } else {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    strategy.onServiceRemove(this.camelContext, service, route);
                }
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService((Object)service);
            } else {
                ServiceHelper.stopService((Object)service);
            }
            this.removeChildService(service);
        }
    }

    private Set<Service> gatherChildServices() {
        ArrayList<Service> services = new ArrayList<Service>(this.route.getServices());
        this.doGetRouteServices(services);
        LinkedHashSet<Service> list = new LinkedHashSet<Service>();
        for (Service service : services) {
            list.addAll(ServiceHelper.getChildServices((Service)service));
        }
        this.doGetErrorHandler(list);
        return list;
    }

    private void doGetErrorHandler(Set<Service> services) {
        ArrayList<Service> extra = new ArrayList<Service>();
        for (Service service : services) {
            Processor eh;
            if (!(service instanceof Channel) || !((eh = ((Channel)service).getErrorHandler()) instanceof Service)) continue;
            extra.add((Service)eh);
        }
        if (!extra.isEmpty()) {
            services.addAll(extra);
        }
    }

    protected void doGetRouteServices(List<Service> services) {
        for (Processor proc : this.getRoute().getOnExceptions()) {
            if (!(proc instanceof Service)) continue;
            services.add((Service)proc);
        }
        for (Processor proc : this.getRoute().getOnCompletions()) {
            if (!(proc instanceof Service)) continue;
            services.add((Service)proc);
        }
    }

    class MDCHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;

        MDCHelper(String routeId) {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)RouteService.this.getCamelContext().getName());
                MDC.put((String)"camel.routeId", (String)routeId);
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
        }
    }
}

