/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pg.replication.slot;

import java.net.SocketException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.pg.replication.slot.PgReplicationSlotEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledPollConsumer;
import org.postgresql.PGConnection;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.fluent.logical.ChainedLogicalCreateSlotBuilder;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgReplicationSlotConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PgReplicationSlotConsumer.class);
    private final PgReplicationSlotEndpoint endpoint;
    private Connection connection;
    private PGConnection pgConnection;
    private PGReplicationStream replicationStream;
    private ScheduledExecutorService scheduledExecutor;
    private byte[] payload;

    PgReplicationSlotConsumer(PgReplicationSlotEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connect();
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "PgReplicationStatusUpdateSender");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
    }

    protected int poll() throws Exception {
        PGReplicationStream stream = this.getStream();
        if (stream == null) {
            return 0;
        }
        try {
            if (this.payload == null) {
                ByteBuffer msg = stream.readPending();
                if (msg == null) {
                    return 0;
                }
                int offset = msg.arrayOffset();
                byte[] source = msg.array();
                int length = source.length - offset;
                this.payload = new byte[length];
                System.arraycopy(source, offset, this.payload, 0, length);
            }
        }
        catch (SQLException e) {
            if (e.getCause() instanceof SocketException) {
                LOG.info("Connection to PosgreSQL server has been lost, trying to reconnect.");
                this.connect();
            }
            throw e;
        }
        Exchange exchange = this.endpoint.createExchange();
        exchange.setExchangeId(stream.getLastReceiveLSN().asString());
        Message message = exchange.getIn();
        message.setBody((Object)this.payload);
        long delay = this.endpoint.getStatusInterval().intValue();
        final ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(() -> {
            try {
                LOG.debug("Processing took too long. Sending status update to avoid disconnect.");
                stream.forceUpdateStatus();
            }
            catch (SQLException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }, delay, delay, TimeUnit.SECONDS);
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

            public void onComplete(Exchange exchange) {
                PgReplicationSlotConsumer.this.processCommit(exchange);
                scheduledFuture.cancel(true);
            }

            public void onFailure(Exchange exchange) {
                PgReplicationSlotConsumer.this.processRollback(exchange);
                scheduledFuture.cancel(true);
            }
        });
        this.getProcessor().process(exchange);
        return 1;
    }

    private void processCommit(Exchange exchange) {
        try {
            this.payload = null;
            PGReplicationStream stream = this.getStream();
            if (stream == null) {
                return;
            }
            stream.setAppliedLSN(stream.getLastReceiveLSN());
            stream.setFlushedLSN(stream.getLastReceiveLSN());
            stream.forceUpdateStatus();
        }
        catch (SQLException e) {
            this.getExceptionHandler().handleException("Exception while sending feedback to PostgreSQL.", exchange, (Throwable)e);
        }
    }

    private void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, (Throwable)cause);
        }
    }

    private void createSlot() throws SQLException {
        ((ChainedLogicalCreateSlotBuilder)this.pgConnection.getReplicationAPI().createReplicationSlot().logical().withSlotName(this.endpoint.getSlot())).withOutputPlugin(this.endpoint.getOutputPlugin()).make();
    }

    /*
     * Exception decompiling
     */
    private boolean isSlotCreated() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PGReplicationStream getStream() throws SQLException {
        if (this.replicationStream != null && !this.replicationStream.isClosed()) {
            return this.replicationStream;
        }
        if (this.isSlotActive()) {
            LOG.debug(String.format("Slot: %s is active. Waiting for it to be available.", this.endpoint.getSlot()));
            return null;
        }
        ChainedLogicalStreamBuilder streamBuilder = (ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)this.pgConnection.getReplicationAPI().replicationStream().logical().withSlotName(this.endpoint.getSlot())).withStatusInterval(this.endpoint.getStatusInterval().intValue(), TimeUnit.SECONDS);
        Properties slotOptions = new Properties();
        slotOptions.putAll(this.endpoint.getSlotOptions());
        streamBuilder.withSlotOptions(slotOptions);
        this.replicationStream = streamBuilder.start();
        return this.replicationStream;
    }

    /*
     * Exception decompiling
     */
    private boolean isSlotActive() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void connect() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = this.endpoint.newDbConnection();
        this.pgConnection = this.connection.unwrap(PGConnection.class);
        this.replicationStream = null;
        if (this.endpoint.getAutoCreateSlot().booleanValue() && !this.isSlotCreated()) {
            this.createSlot();
        }
    }
}

