/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureTransform;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class XmlSignerConfiguration
extends XmlSignatureConfiguration {
    @UriParam
    private XPathFilterParameterSpec parentXpath;
    @UriParam
    private List<XPathFilterParameterSpec> xpathsToIdAttributes = Collections.emptyList();
    @UriParam
    private List<AlgorithmMethod> transformMethods = Collections.singletonList(XmlSignatureHelper.getCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
    @UriParam
    private KeyAccessor keyAccessor;
    @UriParam(defaultValue="http://www.w3.org/TR/2001/REC-xml-c14n-20010315")
    private AlgorithmMethod canonicalizationMethod = new XmlSignatureTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    @UriParam(defaultValue="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")
    private String signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    @UriParam
    private String digestAlgorithm;
    @UriParam(defaultValue="true")
    private Boolean addKeyInfoReference = Boolean.TRUE;
    @UriParam(defaultValue="ds")
    private String prefixForXmlSignatureNamespace = "ds";
    @UriParam
    private String contentObjectId;
    @UriParam
    private String signatureId;
    @UriParam
    private String contentReferenceUri;
    @UriParam
    private String contentReferenceType;
    @UriParam
    private String parentLocalName;
    @UriParam
    private String parentNamespace;
    @UriParam(defaultValue="false")
    private Boolean plainText = Boolean.FALSE;
    @UriParam(defaultValue="UTF-8")
    private String plainTextEncoding = "UTF-8";
    @UriParam
    private XmlSignatureProperties properties;

    public XmlSignerConfiguration copy() {
        try {
            return (XmlSignerConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public KeyAccessor getKeyAccessor() {
        return this.keyAccessor;
    }

    public void setKeyAccessor(KeyAccessor keyAccessor) {
        this.keyAccessor = keyAccessor;
    }

    public AlgorithmMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(AlgorithmMethod canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public List<AlgorithmMethod> getTransformMethods() {
        return this.transformMethods;
    }

    public void setTransformMethods(List<AlgorithmMethod> transformMethods) {
        this.transformMethods = transformMethods;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public Boolean getAddKeyInfoReference() {
        return this.addKeyInfoReference;
    }

    public void setAddKeyInfoReference(Boolean addKeyInfoReference) {
        this.addKeyInfoReference = addKeyInfoReference;
    }

    public String getPrefixForXmlSignatureNamespace() {
        return this.prefixForXmlSignatureNamespace;
    }

    public void setPrefixForXmlSignatureNamespace(String prefixForXmlSignatureNamespace) {
        this.prefixForXmlSignatureNamespace = prefixForXmlSignatureNamespace;
    }

    public String getParentLocalName() {
        return this.parentLocalName;
    }

    public void setParentLocalName(String parentLocalName) {
        this.parentLocalName = parentLocalName;
    }

    public String getParentNamespace() {
        return this.parentNamespace;
    }

    public void setParentNamespace(String parentNamespace) {
        this.parentNamespace = parentNamespace;
    }

    public String getContentObjectId() {
        if (this.contentObjectId == null) {
            this.contentObjectId = "_" + UUID.randomUUID().toString();
        }
        return this.contentObjectId;
    }

    public void setContentObjectId(String contentObjectId) {
        this.contentObjectId = contentObjectId;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public String getContentReferenceUri() {
        return this.contentReferenceUri;
    }

    public void setContentReferenceUri(String referenceUri) {
        this.contentReferenceUri = referenceUri;
    }

    public String getContentReferenceType() {
        return this.contentReferenceType;
    }

    public void setContentReferenceType(String referenceType) {
        this.contentReferenceType = referenceType;
    }

    public Boolean getPlainText() {
        return this.plainText;
    }

    public void setPlainText(Boolean plainText) {
        this.plainText = plainText;
    }

    public String getPlainTextEncoding() {
        return this.plainTextEncoding;
    }

    public void setPlainTextEncoding(String plainTextEncoding) {
        this.plainTextEncoding = plainTextEncoding;
    }

    public XmlSignatureProperties getProperties() {
        return this.properties;
    }

    public void setProperties(XmlSignatureProperties properties) {
        this.properties = properties;
    }

    public List<XPathFilterParameterSpec> getXpathsToIdAttributes() {
        return this.xpathsToIdAttributes;
    }

    public void setXpathsToIdAttributes(List<XPathFilterParameterSpec> xpathsToIdAttributes) {
        this.xpathsToIdAttributes = xpathsToIdAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(xpathsToIdAttributes);
    }

    public XPathFilterParameterSpec getParentXpath() {
        return this.parentXpath;
    }

    public void setParentXpath(XPathFilterParameterSpec parentXpath) {
        this.parentXpath = parentXpath;
    }
}

