/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;

class HelsinkiServiceNowAggregateProcessor
extends AbstractServiceNowProcessor {
    HelsinkiServiceNowAggregateProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", this::retrieveStats);
    }

    private void retrieveStats(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("stats").path(tableName).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_AVG_FIELDS, in).query(ServiceNowParams.SYSPARM_COUNT, in).query(ServiceNowParams.SYSPARM_MIN_FIELDS, in).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_MAX_FIELDS, in).query(ServiceNowParams.SYSPARM_SUM_FIELDS, in).query(ServiceNowParams.SYSPARM_GROUP_BY, in).query(ServiceNowParams.SYSPARM_ORDER_BY, in).query(ServiceNowParams.SYSPARM_HAVING, in).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(responseModel).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

