/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CassandraEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Cassandra CQL component.
     */
    public interface CassandraEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCassandraEndpointConsumerBuilder advanced() {
            return (AdvancedCassandraEndpointConsumerBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cluster(Object cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cluster(String cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder clusterName(String clusterName) {
            doSetProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder consistencyLevel(
                String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder cql(String cql) {
            doSetProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            doSetProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointConsumerBuilder prepareStatements(
                boolean prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointConsumerBuilder prepareStatements(
                String prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder session(Object session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default CassandraEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default CassandraEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CassandraEndpointConsumerBuilder basic() {
            return (CassandraEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedCassandraEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Cassandra CQL component.
     */
    public interface CassandraEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCassandraEndpointProducerBuilder advanced() {
            return (AdvancedCassandraEndpointProducerBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cluster(Object cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cluster(String cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder clusterName(String clusterName) {
            doSetProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder consistencyLevel(
                String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder cql(String cql) {
            doSetProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            doSetProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointProducerBuilder prepareStatements(
                boolean prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointProducerBuilder prepareStatements(
                String prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder session(Object session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CassandraEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default CassandraEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CassandraEndpointProducerBuilder basic() {
            return (CassandraEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Cassandra CQL component.
     */
    public interface CassandraEndpointBuilder
            extends
                CassandraEndpointConsumerBuilder,
                CassandraEndpointProducerBuilder {
        default AdvancedCassandraEndpointBuilder advanced() {
            return (AdvancedCassandraEndpointBuilder) this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cluster(Object cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * To use the Cluster instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Cluster</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cluster(String cluster) {
            doSetProperty("cluster", cluster);
            return this;
        }
        /**
         * Cluster name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder clusterName(String clusterName) {
            doSetProperty("clusterName", clusterName);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option is a:
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder consistencyLevel(
                ConsistencyLevel consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * Consistency level to use.
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.ConsistencyLevel</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder consistencyLevel(
                String consistencyLevel) {
            doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }
        /**
         * CQL query to perform. Can be overridden with the message header with
         * key CamelCqlQuery.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder cql(String cql) {
            doSetProperty("cql", cql);
            return this;
        }
        /**
         * To use a specific LoadBalancingPolicy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder loadBalancingPolicy(
                String loadBalancingPolicy) {
            doSetProperty("loadBalancingPolicy", loadBalancingPolicy);
            return this;
        }
        /**
         * Password for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointBuilder prepareStatements(
                boolean prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * Whether to use PreparedStatements or regular Statements.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default CassandraEndpointBuilder prepareStatements(
                String prepareStatements) {
            doSetProperty("prepareStatements", prepareStatements);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option is a:
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder resultSetConversionStrategy(
                Object resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use a custom class that implements logic for converting ResultSet
         * into message body ALL, ONE, LIMIT_10, LIMIT_100...
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.cassandra.ResultSetConversionStrategy</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder resultSetConversionStrategy(
                String resultSetConversionStrategy) {
            doSetProperty("resultSetConversionStrategy", resultSetConversionStrategy);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option is a: <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder session(Object session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * To use the Session instance (you would normally not use this option).
         * 
         * The option will be converted to a
         * <code>com.datastax.driver.core.Session</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Username for session authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default CassandraEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Cassandra CQL component.
     */
    public interface AdvancedCassandraEndpointBuilder
            extends
                AdvancedCassandraEndpointConsumerBuilder,
                AdvancedCassandraEndpointProducerBuilder {
        default CassandraEndpointBuilder basic() {
            return (CassandraEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedCassandraEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.datastax.driver.core.ConsistencyLevel</code>
     * enum.
     */
    enum ConsistencyLevel {
        ANY,
        ONE,
        TWO,
        THREE,
        QUORUM,
        ALL,
        LOCAL_QUORUM,
        EACH_QUORUM,
        SERIAL,
        LOCAL_SERIAL,
        LOCAL_ONE;
    }

    public interface CassandraBuilders {
        /**
         * Cassandra CQL (camel-cassandraql)
         * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
         * 
         * Category: database,nosql
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-cassandraql
         * 
         * Syntax: <code>cql:beanRef:hosts:port/keyspace</code>
         * 
         * Path parameter: beanRef
         * beanRef is defined using bean:id
         * 
         * Path parameter: hosts
         * Hostname(s) cassansdra server(s). Multiple hosts can be separated by
         * comma.
         * 
         * Path parameter: port
         * Port number of cassansdra server(s)
         * 
         * Path parameter: keyspace
         * Keyspace to use
         * 
         * @param path beanRef:hosts:port/keyspace
         */
        default CassandraEndpointBuilder cql(String path) {
            return CassandraEndpointBuilderFactory.endpointBuilder("cql", path);
        }
        /**
         * Cassandra CQL (camel-cassandraql)
         * Integrate with Cassandra 2.0 using the CQL3 API (not the Thrift API).
         * 
         * Category: database,nosql
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-cassandraql
         * 
         * Syntax: <code>cql:beanRef:hosts:port/keyspace</code>
         * 
         * Path parameter: beanRef
         * beanRef is defined using bean:id
         * 
         * Path parameter: hosts
         * Hostname(s) cassansdra server(s). Multiple hosts can be separated by
         * comma.
         * 
         * Path parameter: port
         * Port number of cassansdra server(s)
         * 
         * Path parameter: keyspace
         * Keyspace to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path beanRef:hosts:port/keyspace
         */
        default CassandraEndpointBuilder cql(String componentName, String path) {
            return CassandraEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static CassandraEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class CassandraEndpointBuilderImpl extends AbstractEndpointBuilder implements CassandraEndpointBuilder, AdvancedCassandraEndpointBuilder {
            public CassandraEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CassandraEndpointBuilderImpl(path);
    }
}