/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ddb.Ddb2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@org.apache.camel.spi.annotations.Component(value="aws2-ddb")
public class Ddb2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Ddb2Component.class);
    @Metadata
    private Ddb2Configuration configuration = new Ddb2Configuration();

    public Ddb2Component() {
        this(null);
    }

    public Ddb2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Ddb2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        Ddb2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Ddb2Configuration();
        configuration.setTableName(remaining);
        Ddb2Endpoint endpoint = new Ddb2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getAmazonDDBClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonDDBClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Ddb2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Ddb2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Ddb2Configuration configuration, Ddb2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonDDBClient())) {
            LOG.debug("Looking for an DynamoDbClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(DynamoDbClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one DynamoDbClient instance in the registry");
                configuration.setAmazonDDBClient((DynamoDbClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No DynamoDbClient instance in the registry");
            }
        } else {
            LOG.debug("DynamoDbClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

