/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.spi.CamelEvent;

public class MicrometerExchangeEventNotifier
extends AbstractMicrometerEventNotifier<CamelEvent.ExchangeEvent> {
    private Predicate<Exchange> ignoreExchanges = exchange -> false;
    private MicrometerExchangeEventNotifierNamingStrategy namingStrategy = MicrometerExchangeEventNotifierNamingStrategy.DEFAULT;

    public MicrometerExchangeEventNotifier() {
        super(CamelEvent.ExchangeEvent.class);
    }

    public void setIgnoreExchanges(Predicate<Exchange> ignoreExchanges) {
        this.ignoreExchanges = ignoreExchanges;
    }

    public Predicate<Exchange> getIgnoreExchanges() {
        return this.ignoreExchanges;
    }

    public MicrometerExchangeEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void notify(CamelEvent eventObject) {
        if (!this.getIgnoreExchanges().test(((CamelEvent.ExchangeEvent)eventObject).getExchange())) {
            if (eventObject instanceof CamelEvent.ExchangeSentEvent) {
                this.handleSentEvent((CamelEvent.ExchangeSentEvent)eventObject);
            } else if (eventObject instanceof CamelEvent.ExchangeCreatedEvent) {
                this.handleCreatedEvent((CamelEvent.ExchangeCreatedEvent)eventObject);
            } else if (eventObject instanceof CamelEvent.ExchangeCompletedEvent || eventObject instanceof CamelEvent.ExchangeFailedEvent) {
                this.handleDoneEvent((CamelEvent.ExchangeEvent)eventObject);
            }
        }
    }

    protected void handleSentEvent(CamelEvent.ExchangeSentEvent sentEvent) {
        String name = this.namingStrategy.getName(sentEvent.getExchange(), sentEvent.getEndpoint());
        Tags tags = this.namingStrategy.getTags((CamelEvent.ExchangeEvent)sentEvent, sentEvent.getEndpoint());
        this.getMeterRegistry().timer(name, (Iterable)tags).record(sentEvent.getTimeTaken(), TimeUnit.MILLISECONDS);
    }

    protected void handleCreatedEvent(CamelEvent.ExchangeCreatedEvent createdEvent) {
        String name = this.namingStrategy.getName(createdEvent.getExchange(), createdEvent.getExchange().getFromEndpoint());
        createdEvent.getExchange().setProperty("eventTimer:" + name, (Object)Timer.start((MeterRegistry)this.getMeterRegistry()));
    }

    protected void handleDoneEvent(CamelEvent.ExchangeEvent doneEvent) {
        String name = this.namingStrategy.getName(doneEvent.getExchange(), doneEvent.getExchange().getFromEndpoint());
        Tags tags = this.namingStrategy.getTags(doneEvent, doneEvent.getExchange().getFromEndpoint());
        Timer.Sample sample = (Timer.Sample)doneEvent.getExchange().removeProperty("eventTimer:" + name);
        if (sample != null) {
            sample.stop(this.getMeterRegistry().timer(name, (Iterable)tags));
        }
    }
}

