/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final CamelContext camelContext;
    private final ReactiveExecutor reactiveExecutor;
    private final List<AsyncProcessor> processors;
    private final int size;
    private String id;
    private String routeId;

    public Pipeline(CamelContext camelContext, Collection<Processor> processors) {
        this.camelContext = camelContext;
        this.reactiveExecutor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        this.processors = processors.stream().map(AsyncProcessorConverterHelper::convert).collect(Collectors.toList());
        this.size = processors.size();
    }

    public static Processor newInstance(CamelContext camelContext, List<Processor> processors) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        return new Pipeline(camelContext, processors);
    }

    public static Processor newInstance(CamelContext camelContext, Processor ... processors) {
        if (processors == null || processors.length == 0) {
            return null;
        }
        if (processors.length == 1) {
            return processors[0];
        }
        ArrayList<Processor> toBeProcessed = new ArrayList<Processor>(processors.length);
        for (Processor processor : processors) {
            if (processor == null) continue;
            toBeProcessed.add(processor);
        }
        return new Pipeline(camelContext, toBeProcessed);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        PipelineTask task = new PipelineTask(exchange, callback, new AtomicInteger());
        if (exchange.isTransacted()) {
            this.reactiveExecutor.scheduleSync((Runnable)task);
        } else {
            this.reactiveExecutor.scheduleMain((Runnable)task);
        }
        return false;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processors);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processors);
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "pipeline";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<AsyncProcessor>(this.processors);
    }

    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    private final class PipelineTask
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final AtomicInteger index;

        PipelineTask(Exchange exchange, AsyncCallback callback, AtomicInteger index) {
            this.exchange = exchange;
            this.callback = callback;
            this.index = index;
        }

        @Override
        public void run() {
            boolean first;
            boolean stop = this.exchange.isRouteStop();
            int num = this.index.get();
            boolean more = num < Pipeline.this.size;
            boolean bl = first = num == 0;
            if (!stop && more && (first || PipelineHelper.continueProcessing(this.exchange, "so breaking out of pipeline", LOG))) {
                if (this.exchange.hasOut()) {
                    this.exchange.setIn(this.exchange.getOut());
                    this.exchange.setOut(null);
                }
                AsyncProcessor processor = (AsyncProcessor)Pipeline.this.processors.get(this.index.getAndIncrement());
                processor.process(this.exchange, doneSync -> Pipeline.this.reactiveExecutor.schedule((Runnable)this));
            } else {
                ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)this.exchange);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
                Pipeline.this.reactiveExecutor.schedule((Runnable)this.callback);
            }
        }
    }
}

