/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.as2.api.entity.ApplicationEDIConsentEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIFACTEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIX12Entity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EntityUtils.class);
    private static AtomicLong partNumber = new AtomicLong();

    private EntityUtils() {
    }

    public static String createBoundaryValue() {
        StringBuffer s = new StringBuffer();
        s.append("----=_Part_").append(partNumber.incrementAndGet()).append("_").append(s.hashCode()).append(".").append(System.currentTimeMillis());
        return s.toString();
    }

    public static boolean validateBoundaryValue(String boundaryValue) {
        return true;
    }

    public static String appendParameter(String headerString, String parameterName, String parameterValue) {
        return headerString + "; " + parameterName + "=" + parameterValue;
    }

    public static String encode(String data, Charset charset, String encoding) throws Exception {
        byte[] encoded = EntityUtils.encode(data.getBytes(charset), encoding);
        return new String(encoded, charset);
    }

    public static byte[] encode(byte[] data, String encoding) throws Exception {
        Args.notNull((Object)data, (String)"Data");
        if (encoding == null) {
            return data;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return Base64.encode((byte[])data);
            }
            case "quoted-printable": {
                return QuotedPrintableCodec.encodeQuotedPrintable(null, (byte[])data);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return data;
            }
        }
        throw new Exception("Unknown encoding: " + encoding);
    }

    public static OutputStream encode(OutputStream os, String encoding) throws Exception {
        Args.notNull((Object)os, (String)"Output Stream");
        if (encoding == null) {
            return os;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return new Base64OutputStream(os, true);
            }
            case "quoted-printable": {
                return new Base64OutputStream(os, true);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return os;
            }
        }
        throw new Exception("Unknown encoding: " + encoding);
    }

    public static String decode(String data, Charset charset, String encoding) throws Exception {
        byte[] decoded = EntityUtils.decode(data.getBytes(charset), encoding);
        return new String(decoded, charset);
    }

    public static byte[] decode(byte[] data, String encoding) throws Exception {
        Args.notNull((Object)data, (String)"Data");
        if (encoding == null) {
            return data;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return Base64.decode((byte[])data);
            }
            case "quoted-printable": {
                return QuotedPrintableCodec.decodeQuotedPrintable((byte[])data);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return data;
            }
        }
        throw new Exception("Unknown encoding: " + encoding);
    }

    public static InputStream decode(InputStream is, String encoding) throws Exception {
        Args.notNull((Object)is, (String)"Input Stream");
        if (encoding == null) {
            return is;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return new Base64InputStream(is, false);
            }
            case "quoted-printable": {
                return new Base64InputStream(is, false);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return is;
            }
        }
        throw new Exception("Unknown encoding: " + encoding);
    }

    public static ApplicationEDIEntity createEDIEntity(String ediMessage, ContentType ediMessageContentType, String contentTransferEncoding, boolean isMainBody) throws Exception {
        Args.notNull((Object)ediMessage, (String)"EDI Message");
        Args.notNull((Object)ediMessageContentType, (String)"EDI Message Content Type");
        String charset = ediMessageContentType.getCharset() == null ? "US-ASCII" : ediMessageContentType.getCharset().toString();
        switch (ediMessageContentType.getMimeType().toLowerCase()) {
            case "application/edifact": {
                return new ApplicationEDIFACTEntity(ediMessage, charset, contentTransferEncoding, isMainBody);
            }
            case "application/edi-x12": {
                return new ApplicationEDIX12Entity(ediMessage, charset, contentTransferEncoding, isMainBody);
            }
            case "application/edi-consent": {
                return new ApplicationEDIConsentEntity(ediMessage, charset, contentTransferEncoding, isMainBody);
            }
        }
        throw new Exception("Invalid EDI entity mime type: " + ediMessageContentType.getMimeType());
    }

    public static byte[] getContent(HttpEntity entity) {
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)outstream);
            outstream.flush();
            return outstream.toByteArray();
        }
        catch (Exception e) {
            LOG.debug("failed to get content", (Throwable)e);
            return null;
        }
    }

    public static boolean hasEntity(HttpMessage message) {
        boolean hasEntity = false;
        if (message instanceof HttpEntityEnclosingRequest) {
            hasEntity = ((HttpEntityEnclosingRequest)message).getEntity() != null;
        } else if (message instanceof HttpResponse) {
            hasEntity = ((HttpResponse)message).getEntity() != null;
        }
        return hasEntity;
    }

    public static HttpEntity getMessageEntity(HttpMessage message) {
        if (message instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)message).getEntity();
        }
        if (message instanceof HttpResponse) {
            return ((HttpResponse)message).getEntity();
        }
        return null;
    }

    public static void setMessageEntity(HttpMessage message, HttpEntity entity) {
        Header contentTransferEncodingHeader;
        if (message instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequest)message).setEntity(entity);
        } else if (message instanceof HttpResponse) {
            ((HttpResponse)message).setEntity(entity);
        }
        Header contentTypeHeader = entity.getContentType();
        if (contentTypeHeader != null) {
            message.setHeader(contentTypeHeader);
        }
        if (entity instanceof MimeEntity && (contentTransferEncodingHeader = ((MimeEntity)entity).getContentTransferEncoding()) != null) {
            message.setHeader(contentTransferEncodingHeader);
        }
        long contentLength = entity.getContentLength();
        message.setHeader("Content-Length", Long.toString(contentLength));
    }

    public static byte[] decodeTransferEncodingOfBodyPartContent(String bodyPartContent, ContentType contentType, String bodyPartTransferEncoding) throws Exception {
        Args.notNull((Object)bodyPartContent, (String)"bodyPartContent");
        Charset contentCharset = contentType.getCharset();
        if (contentCharset == null) {
            contentCharset = StandardCharsets.US_ASCII;
        }
        return EntityUtils.decode(bodyPartContent.getBytes(contentCharset), bodyPartTransferEncoding);
    }

    public static void printEntity(PrintStream out, HttpEntity entity) throws IOException {
        entity.writeTo((OutputStream)out);
    }

    public static String printEntity(HttpEntity entity) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");
            try {
                String content;
                EntityUtils.printEntity(ps, entity);
                String string = content = baos.toString(StandardCharsets.UTF_8.name());
                ps.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

