/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Store and retrieve blobs from Azure Storage Blob Service using SDK v12.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BlobEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBlobEndpointConsumerBuilder advanced() {
            return (AdvancedBlobEndpointConsumerBuilder) this;
        }
        /**
         * The blob name, required for consumer. However on producer, is only
         * required for the operations on the blob level.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointConsumerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointConsumerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BlobEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default BlobEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BlobEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BlobEndpointConsumerBuilder basic() {
            return (BlobEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBlobEndpointProducerBuilder advanced() {
            return (AdvancedBlobEndpointProducerBuilder) this;
        }
        /**
         * The blob name, required for consumer. However on producer, is only
         * required for the operations on the blob level.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointProducerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointProducerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointProducerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointProducerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointProducerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                boolean closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                String closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BlobEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default BlobEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition</code> type.
         * 
         * Default: listBlobContainers
         * Group: producer
         */
        default BlobEndpointProducerBuilder operation(
                BlobOperationsDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition</code> type.
         * 
         * Default: listBlobContainers
         * Group: producer
         */
        default BlobEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BlobEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BlobEndpointProducerBuilder basic() {
            return (BlobEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Blob Service component.
     */
    public interface BlobEndpointBuilder
            extends
                BlobEndpointConsumerBuilder,
                BlobEndpointProducerBuilder {
        default AdvancedBlobEndpointBuilder advanced() {
            return (AdvancedBlobEndpointBuilder) this;
        }
        /**
         * The blob name, required for consumer. However on producer, is only
         * required for the operations on the blob level.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder blobServiceClient(Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder blobServiceClient(String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.azure.storage.blob.BlobType</code>
         * type.
         * 
         * Default: blockblob
         * Group: common
         */
        default BlobEndpointBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointBuilder maxRetryRequests(int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default BlobEndpointBuilder maxRetryRequests(String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * <code>com.azure.storage.blob.BlobServiceClient</code> type.
         * 
         * Group: common
         */
        default BlobEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default BlobEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Blob Service
     * component.
     */
    public interface AdvancedBlobEndpointBuilder
            extends
                AdvancedBlobEndpointConsumerBuilder,
                AdvancedBlobEndpointProducerBuilder {
        default BlobEndpointBuilder basic() {
            return (BlobEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedBlobEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.storage.blob.BlobType</code> enum.
     */
    enum BlobType {
        blockblob,
        appendblob,
        pageblob;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition</code> enum.
     */
    enum BlobOperationsDefinition {
        listBlobContainers,
        createBlobContainer,
        deleteBlobContainer,
        listBlobs,
        getBlob,
        deleteBlob,
        downloadBlobToFile,
        downloadLink,
        uploadBlockBlob,
        stageBlockBlobList,
        commitBlobBlockList,
        getBlobBlockList,
        createAppendBlob,
        commitAppendBlob,
        createPageBlob,
        uploadPageBlob,
        resizePageBlob,
        clearPageBlob,
        getPageBlobRanges;
    }

    public interface BlobBuilders {
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service using SDK
         * v12.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param path containerName
         */
        default BlobEndpointBuilder azureStorageBlob(String path) {
            return BlobEndpointBuilderFactory.endpointBuilder("azure-storage-blob", path);
        }
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service using SDK
         * v12.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path containerName
         */
        default BlobEndpointBuilder azureStorageBlob(
                String componentName,
                String path) {
            return BlobEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static BlobEndpointBuilder endpointBuilder(String componentName, String path) {
        class BlobEndpointBuilderImpl extends AbstractEndpointBuilder implements BlobEndpointBuilder, AdvancedBlobEndpointBuilder {
            public BlobEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new BlobEndpointBuilderImpl(path);
    }
}