/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jgroups.raft.JGroupsRaftConsumer;
import org.apache.camel.component.jgroups.raft.JGroupsRaftProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.24.0", scheme="jgroups-raft", title="JGroups raft", syntax="jgroup-raft:clusterName", category={Category.CLUSTERING, Category.MESSAGING})
public class JGroupsRaftEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsRaftEndpoint.class);
    private AtomicInteger connectCount = new AtomicInteger(0);
    private RaftHandle raftHandle;
    private RaftHandle resolvedRaftHandle;
    private StateMachine stateMachine;
    private String raftId;
    private String channelProperties;
    @UriPath
    @Metadata(required=true)
    private String clusterName;
    @UriParam(label="consumer", defaultValue="false")
    private boolean enableRoleChangeEvents;

    public JGroupsRaftEndpoint(String endpointUri, String clusterName, Component component, String remaining, Map<String, Object> parameters, String raftId, String channelProperties, StateMachine stateMachine, RaftHandle raftHandle) {
        super(endpointUri, component);
        this.clusterName = clusterName;
        this.raftId = raftId;
        this.channelProperties = channelProperties;
        this.stateMachine = stateMachine;
        this.raftHandle = raftHandle;
    }

    public Producer createProducer() throws Exception {
        return new JGroupsRaftProducer(this, this.resolvedRaftHandle, this.clusterName);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new JGroupsRaftConsumer(this, processor, this.resolvedRaftHandle, this.clusterName, this.enableRoleChangeEvents);
    }

    public Exchange createExchange() {
        Exchange exchange = super.createExchange();
        this.populateJGroupsRaftHeaders(exchange);
        return exchange;
    }

    public void populateJGroupsRaftHeaders(Exchange exchange) {
        exchange.getIn().setHeader("JGROUPSRAFT_COMMIT_INDEX", (Object)this.resolvedRaftHandle.commitIndex());
        exchange.getIn().setHeader("JGROUPSRAFT_CURRENT_TERM", (Object)this.resolvedRaftHandle.currentTerm());
        exchange.getIn().setHeader("JGROUPSRAFT_IS_LEADER", (Object)this.resolvedRaftHandle.isLeader());
        exchange.getIn().setHeader("JGROUPSRAFT_LAST_APPLIED", (Object)this.resolvedRaftHandle.lastApplied());
        exchange.getIn().setHeader("JGROUPSRAFT_LEADER_ADDRESS", (Object)this.resolvedRaftHandle.leader());
        exchange.getIn().setHeader("JGROUPSRAFT_LOG_SIZE", (Object)this.resolvedRaftHandle.logSize());
        exchange.getIn().setHeader("JGROUPSRAFT_LOG_SIZE_BYTE", (Object)this.resolvedRaftHandle.logSizeInBytes());
        exchange.getIn().setHeader("JGROUPSRAFT_RAFT_ID", (Object)this.resolvedRaftHandle.raftId());
    }

    protected void doStart() throws Exception {
        LOG.info("Resolving JGroupsraft handle {}", (Object)this.getEndpointUri());
        super.doStart();
        this.resolvedRaftHandle = this.resolveHandle();
    }

    protected void doStop() throws Exception {
        LOG.info("Closing JGroupsraft Channel {}", (Object)this.getEndpointUri());
        if (this.resolvedRaftHandle != null && this.resolvedRaftHandle.channel() != null) {
            this.resolvedRaftHandle.channel().close();
            LOG.info("Closed JGroupsraft Channel {}", (Object)this.getEndpointUri());
        }
        LOG.info("Closing Log {}", (Object)this.getEndpointUri());
        if (this.resolvedRaftHandle != null && this.resolvedRaftHandle.log() != null) {
            this.resolvedRaftHandle.log().close();
            LOG.info("Closed Log Channel {}", (Object)this.getEndpointUri());
        }
        super.doStop();
    }

    private RaftHandle resolveHandle() throws Exception {
        if (this.raftHandle != null) {
            LOG.trace("Raft Handle resolved as passed by Component: {}", (Object)this.raftHandle);
            return this.raftHandle;
        }
        if (this.channelProperties != null && !this.channelProperties.isEmpty()) {
            LOG.trace("Raft Handle created with configured channelProperties: {} and state machine: {}", (Object)this.channelProperties, (Object)this.stateMachine);
            return new RaftHandle(new JChannel(this.channelProperties).name(this.raftId), this.stateMachine).raftId(this.raftId);
        }
        LOG.trace("Raft Handle created with defaults: {}, {},", (Object)"raft.xml", (Object)this.stateMachine);
        return new RaftHandle(new JChannel("raft.xml").name(this.raftId), this.stateMachine).raftId(this.raftId);
    }

    public void connect() throws Exception {
        this.connectCount.incrementAndGet();
        LOG.trace("Connecting JGroups-raft Channel {} with cluster name: {}, raftHandle: {} and using config: {}", new Object[]{this.getEndpointUri(), this.clusterName, this.resolvedRaftHandle, this.channelProperties == null ? "default" : this.channelProperties});
        this.resolvedRaftHandle.channel().connect(this.clusterName);
    }

    public void disconnect() {
        if (this.connectCount.decrementAndGet() == 0) {
            LOG.trace("Disconnecting JGroupsraft Channel {}", (Object)this.getEndpointUri());
            this.resolvedRaftHandle.channel().disconnect();
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isEnableRoleChangeEvents() {
        return this.enableRoleChangeEvents;
    }

    public void setEnableRoleChangeEvents(boolean enableRoleChangeEvents) {
        this.enableRoleChangeEvents = enableRoleChangeEvents;
    }

    public String getChannelProperties() {
        return this.channelProperties;
    }

    public void setChannelProperties(String channelProperties) {
        this.channelProperties = channelProperties;
    }

    public String getRaftId() {
        return this.raftId;
    }

    public void setRaftId(String raftId) {
        this.raftId = raftId;
    }

    public RaftHandle getRaftHandle() {
        return this.raftHandle;
    }

    public void setRaftHandle(RaftHandle raftHandle) {
        this.raftHandle = raftHandle;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public RaftHandle getResolvedRaftHandle() {
        return this.resolvedRaftHandle;
    }
}

