/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.kafka.AWSKafka;
import com.amazonaws.services.kafka.model.BrokerNodeGroupInfo;
import com.amazonaws.services.kafka.model.CreateClusterRequest;
import com.amazonaws.services.kafka.model.CreateClusterResult;
import com.amazonaws.services.kafka.model.DeleteClusterRequest;
import com.amazonaws.services.kafka.model.DeleteClusterResult;
import com.amazonaws.services.kafka.model.DescribeClusterRequest;
import com.amazonaws.services.kafka.model.DescribeClusterResult;
import com.amazonaws.services.kafka.model.ListClustersRequest;
import com.amazonaws.services.kafka.model.ListClustersResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKEndpoint;
import org.apache.camel.component.aws.msk.MSKOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSKProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MSKProducer.class);
    private transient String mskProducerToString;

    public MSKProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listClusters: {
                this.listClusters(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case createCluster: {
                this.createCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case deleteCluster: {
                this.deleteCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            case describeCluster: {
                this.describeCluster(this.getEndpoint().getMskClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private MSKOperations determineOperation(Exchange exchange) {
        MSKOperations operation = (MSKOperations)((Object)exchange.getIn().getHeader("CamelAwsMSKOperation", MSKOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected MSKConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.mskProducerToString == null) {
            this.mskProducerToString = "MSKProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.mskProducerToString;
    }

    public MSKEndpoint getEndpoint() {
        return (MSKEndpoint)super.getEndpoint();
    }

    private void listClusters(AWSKafka mskClient, Exchange exchange) {
        ListClustersResult result;
        ListClustersRequest request = new ListClustersRequest();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterFilter"))) {
            String filter = (String)exchange.getIn().getHeader("CamelAwsMSKClusterFilter", String.class);
            request.withClusterNameFilter(filter);
        }
        try {
            result = mskClient.listClusters(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("List Clusters command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MSKProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createCluster(AWSKafka mskClient, Exchange exchange) {
        CreateClusterResult result;
        CreateClusterRequest request = new CreateClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterName"))) {
            throw new IllegalArgumentException("Cluster Name must be specified");
        }
        String name = (String)exchange.getIn().getHeader("CamelAwsMSKClusterName", String.class);
        request.withClusterName(name);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterKafkaVersion"))) {
            throw new IllegalArgumentException("Kafka Version must be specified");
        }
        String version = (String)exchange.getIn().getHeader("CamelAwsMSKClusterKafkaVersion", String.class);
        request.withKafkaVersion(version);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesNumber"))) {
            throw new IllegalArgumentException("Kafka Version must be specified");
        }
        Integer nodesNumber = (Integer)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesNumber", Integer.class);
        request.withNumberOfBrokerNodes(nodesNumber);
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesGroupInfo"))) {
            throw new IllegalArgumentException("BrokerNodeGroupInfo must be specified");
        }
        BrokerNodeGroupInfo brokerNodesGroupInfo = (BrokerNodeGroupInfo)exchange.getIn().getHeader("CamelAwsMSKBrokerNodesGroupInfo", BrokerNodeGroupInfo.class);
        request.withBrokerNodeGroupInfo(brokerNodesGroupInfo);
        try {
            result = mskClient.createCluster(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Create Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MSKProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteCluster(AWSKafka mskClient, Exchange exchange) {
        DeleteClusterResult result;
        DeleteClusterRequest request = new DeleteClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterArn"))) {
            throw new IllegalArgumentException("Cluster ARN must be specified");
        }
        String arn = (String)exchange.getIn().getHeader("CamelAwsMSKClusterArn", String.class);
        request.withClusterArn(arn);
        try {
            result = mskClient.deleteCluster(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MSKProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void describeCluster(AWSKafka mskClient, Exchange exchange) {
        DescribeClusterResult result;
        DescribeClusterRequest request = new DescribeClusterRequest();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMSKClusterArn"))) {
            throw new IllegalArgumentException("Cluster ARN must be specified");
        }
        String arn = (String)exchange.getIn().getHeader("CamelAwsMSKClusterArn", String.class);
        request.withClusterArn(arn);
        try {
            result = mskClient.describeCluster(request);
        }
        catch (AmazonServiceException ase) {
            LOG.trace("Delete Cluster command returned the error code {}", (Object)ase.getErrorCode());
            throw ase;
        }
        Message message = MSKProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

