/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.ddb.Ddb2Component;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class Ddb2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Ddb2Configuration getOrCreateConfiguration(Ddb2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Ddb2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Ddb2Component target = (Ddb2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonddbclient": 
            case "amazonDDBClient": {
                this.getOrCreateConfiguration(target).setAmazonDDBClient((DynamoDbClient)Ddb2ComponentConfigurer.property((CamelContext)camelContext, DynamoDbClient.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Ddb2Configuration)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Ddb2Configuration.class, (Object)value));
                return true;
            }
            case "consistentread": 
            case "consistentRead": {
                this.getOrCreateConfiguration(target).setConsistentRead((Boolean)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyattributename": 
            case "keyAttributeName": {
                this.getOrCreateConfiguration(target).setKeyAttributeName((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyattributetype": 
            case "keyAttributeType": {
                this.getOrCreateConfiguration(target).setKeyAttributeType((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((Ddb2Operations)((Object)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Ddb2Operations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "readcapacity": 
            case "readCapacity": {
                this.getOrCreateConfiguration(target).setReadCapacity((Long)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Ddb2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "writecapacity": 
            case "writeCapacity": {
                this.getOrCreateConfiguration(target).setWriteCapacity((Long)Ddb2ComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonDDBClient", DynamoDbClient.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", Ddb2Configuration.class);
        answer.put("consistentRead", Boolean.TYPE);
        answer.put("keyAttributeName", String.class);
        answer.put("keyAttributeType", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", Ddb2Operations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("readCapacity", Long.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("writeCapacity", Long.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Ddb2Component target = (Ddb2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonddbclient": 
            case "amazonDDBClient": {
                return this.getOrCreateConfiguration(target).getAmazonDDBClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consistentread": 
            case "consistentRead": {
                return this.getOrCreateConfiguration(target).isConsistentRead();
            }
            case "keyattributename": 
            case "keyAttributeName": {
                return this.getOrCreateConfiguration(target).getKeyAttributeName();
            }
            case "keyattributetype": 
            case "keyAttributeType": {
                return this.getOrCreateConfiguration(target).getKeyAttributeType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "readcapacity": 
            case "readCapacity": {
                return this.getOrCreateConfiguration(target).getReadCapacity();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "writecapacity": 
            case "writeCapacity": {
                return this.getOrCreateConfiguration(target).getWriteCapacity();
            }
        }
        return null;
    }
}

