/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldif;

import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.ldif.LdifEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LdifProducer.class);
    private static final String LDIF_HEADER = "version: 1";
    private String ldapConnectionName;

    public LdifProducer(LdifEndpoint endpoint, String ldapConnectionName) throws Exception {
        super((Endpoint)endpoint);
        this.ldapConnectionName = ldapConnectionName;
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getIn().getBody(String.class);
        List<String> result = null;
        exchange.setOut(exchange.getIn());
        if (ObjectHelper.isEmpty((Object)body)) {
            exchange.getOut().setBody((Object)"");
        } else if (body.startsWith(LDIF_HEADER)) {
            LOG.debug("Reading from LDIF body");
            result = this.processLdif(new StringReader(body));
        } else {
            try {
                URL loc = new URL(body);
                LOG.debug("Reading from URL: {}", (Object)loc);
                result = this.processLdif(new InputStreamReader(loc.openStream()));
            }
            catch (MalformedURLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to parse body as URL and LDIF", (Throwable)e);
                }
                throw new InvalidPayloadException(exchange, String.class);
            }
        }
        exchange.getOut().setBody(result);
    }

    protected LdapConnection getLdapConnection() throws CamelException {
        return (LdapConnection)this.getEndpoint().getCamelContext().getRegistry().lookupByName(this.ldapConnectionName);
    }

    private List<String> processLdif(Reader reader) throws CamelException {
        LdifReader ldifReader;
        LdapConnection conn = this.getLdapConnection();
        ArrayList<String> results = new ArrayList<String>();
        try {
            ldifReader = new LdifReader(reader);
        }
        catch (LdapException e) {
            throw new CamelException("Unable to create LDIF reader", (Throwable)e);
        }
        for (LdifEntry e : ldifReader) {
            results.add(this.processLdifEntry(conn, e));
        }
        IOHelper.close((Closeable[])new Closeable[]{conn, ldifReader, reader});
        return results;
    }

    private String processLdifEntry(LdapConnection conn, LdifEntry ldifEntry) {
        try {
            if (ldifEntry.isChangeAdd() || ldifEntry.isLdifContent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("attempting add of {}", (Object)ldifEntry);
                }
                conn.add(ldifEntry.getEntry());
            } else if (ldifEntry.isChangeModify()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("attempting modify of {}", (Object)ldifEntry);
                }
                conn.modify(ldifEntry.getDn(), ldifEntry.getModificationArray());
            } else if (ldifEntry.isChangeDelete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("attempting delete of {}", (Object)ldifEntry);
                }
                conn.delete(ldifEntry.getDn());
            } else if (ldifEntry.isChangeModDn()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("attempting DN move of {}", (Object)ldifEntry);
                }
                conn.moveAndRename(ldifEntry.getDn(), new Dn(new String[]{ldifEntry.getNewRdn(), ldifEntry.getNewSuperior()}), ldifEntry.isDeleteOldRdn());
            } else if (ldifEntry.isChangeModRdn()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("attempting RDN move of {}", (Object)ldifEntry);
                }
                conn.rename(ldifEntry.getDn(), new Rdn(ldifEntry.getNewRdn()), ldifEntry.isDeleteOldRdn());
            }
            LOG.debug("ldif success");
            return "success";
        }
        catch (LdapException e) {
            LOG.debug("failed to apply ldif", (Throwable)e);
            return this.getRootCause(e);
        }
    }

    private String getRootCause(LdapException e) {
        Throwable thist;
        LdapException oldt = thist;
        for (thist = e; thist != null; thist = thist.getCause()) {
            oldt = thist;
        }
        return oldt.getMessage();
    }
}

