/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldif;

import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ldif.LdifComponent;
import org.apache.camel.component.ldif.LdifProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.20.0", scheme="ldif", title="LDIF", syntax="ldif:ldapConnectionName", producerOnly=true, category={Category.LDAP})
public class LdifEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String ldapConnectionName;

    protected LdifEndpoint(String endpointUri, String remaining, LdifComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.ldapConnectionName = remaining;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("An LDIF Consumer would be the LDAP server itself! No such support here");
    }

    public Producer createProducer() throws Exception {
        return new LdifProducer(this, this.ldapConnectionName);
    }

    public String getLdapConnectionName() {
        return this.ldapConnectionName;
    }

    public void setLdapConnectionName(String ldapConnectionName) {
        this.ldapConnectionName = ldapConnectionName;
    }
}

