/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.concurrent.Callable;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.quickfixj.CannotSendException;
import org.apache.camel.component.quickfixj.MessageCorrelator;
import org.apache.camel.component.quickfixj.QuickfixjEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;

public class QuickfixjProducer
extends DefaultProducer {
    public static final String CORRELATION_TIMEOUT_KEY = "CorrelationTimeout";
    public static final String CORRELATION_CRITERIA_KEY = "CorrelationCriteria";
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjProducer.class);

    public QuickfixjProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public QuickfixjEndpoint getEndpoint() {
        return (QuickfixjEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.getEndpoint().ensureInitialized();
            this.sendMessage(exchange, exchange.getIn());
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    void sendMessage(Exchange exchange, Message camelMessage) throws Exception {
        Session session;
        quickfix.Message message = (quickfix.Message)camelMessage.getBody(quickfix.Message.class);
        LOG.debug("Sending FIX message: {}", (Object)message);
        SessionID messageSessionID = this.getEndpoint().getSessionID();
        if (messageSessionID == null) {
            messageSessionID = MessageUtils.getSessionID((quickfix.Message)message);
        }
        if ((session = this.getSession(messageSessionID)) == null) {
            throw new IllegalStateException("Unknown session: " + messageSessionID);
        }
        Callable<quickfix.Message> callable = null;
        if (exchange.getPattern().isOutCapable()) {
            MessageCorrelator messageCorrelator = this.getEndpoint().getEngine().getMessageCorrelator();
            callable = messageCorrelator.getReply(this.getEndpoint().getSessionID(), exchange);
        }
        if (!session.send(message)) {
            throw new CannotSendException("Cannot send FIX message: " + message.toString());
        }
        if (callable != null) {
            quickfix.Message reply = (quickfix.Message)callable.call();
            exchange.getOut().getHeaders().putAll(camelMessage.getHeaders());
            exchange.getOut().setBody((Object)reply);
        }
    }

    Session getSession(SessionID messageSessionID) {
        return Session.lookupSession((SessionID)messageSessionID);
    }
}

