/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.util.ObjectHelper;

public class DockerClientProfile {
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String email;
    private String serverAddress;
    private Integer requestTimeout;
    private Boolean secure;
    private String certPath;
    private Integer maxTotalConnections;
    private Integer maxPerRouteConnections;
    private Boolean tlsVerify;
    private Boolean socket;
    private String cmdExecFactory;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Integer getMaxPerRouteConnections() {
        return this.maxPerRouteConnections;
    }

    public void setMaxPerRouteConnections(Integer maxPerRouteConnections) {
        this.maxPerRouteConnections = maxPerRouteConnections;
    }

    public String toUrl() throws DockerException {
        ObjectHelper.notNull((Object)this.host, (String)"host");
        if (this.socket != null && this.socket.booleanValue()) {
            return String.format("unix://%s", this.host);
        }
        ObjectHelper.notNull((Object)this.port, (String)"port");
        return String.format("tcp://%s:%d", this.host, this.port);
    }

    public Boolean isTlsVerify() {
        return this.tlsVerify;
    }

    public void setTlsVerify(Boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public Boolean isSocket() {
        return this.socket;
    }

    public void setSocket(Boolean socket) {
        this.socket = socket;
    }

    public String getCmdExecFactory() {
        return this.cmdExecFactory;
    }

    public void setCmdExecFactory(String cmdExecFactory) {
        this.cmdExecFactory = cmdExecFactory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certPath == null ? 0 : this.certPath.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.tlsVerify == null ? 0 : this.tlsVerify.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.socket == null ? 0 : this.socket.hashCode());
        result = 31 * result + (this.maxPerRouteConnections == null ? 0 : this.maxPerRouteConnections.hashCode());
        result = 31 * result + (this.maxTotalConnections == null ? 0 : this.maxTotalConnections.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.requestTimeout == null ? 0 : this.requestTimeout.hashCode());
        result = 31 * result + (this.secure == null ? 0 : this.secure.hashCode());
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.cmdExecFactory == null ? 0 : this.cmdExecFactory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerClientProfile other = (DockerClientProfile)obj;
        if (this.certPath == null ? other.certPath != null : !this.certPath.equals(other.certPath)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.socket == null ? other.socket != null : !this.socket.equals(other.socket)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.tlsVerify == null ? other.tlsVerify != null : !this.tlsVerify.equals(other.tlsVerify)) {
            return false;
        }
        if (this.maxPerRouteConnections == null ? other.maxPerRouteConnections != null : !this.maxPerRouteConnections.equals(other.maxPerRouteConnections)) {
            return false;
        }
        if (this.maxTotalConnections == null ? other.maxTotalConnections != null : !this.maxTotalConnections.equals(other.maxTotalConnections)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.requestTimeout == null ? other.requestTimeout != null : !this.requestTimeout.equals(other.requestTimeout)) {
            return false;
        }
        if (this.secure == null ? other.secure != null : !this.secure.equals(other.secure)) {
            return false;
        }
        if (this.serverAddress == null ? other.serverAddress != null : !this.serverAddress.equals(other.serverAddress)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        return !(this.cmdExecFactory == null ? other.cmdExecFactory != null : !this.cmdExecFactory.equals(other.cmdExecFactory));
    }
}

