/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CanonicalOutputStream
extends FilterOutputStream {
    private static byte[] newline = new byte[2];
    private int lastByte;
    private String charset;

    public CanonicalOutputStream(OutputStream out, String charset) {
        super(out);
        this.charset = charset;
        this.lastByte = -1;
    }

    @Override
    public void write(int i) throws IOException {
        if (i == 13) {
            this.out.write(newline);
        } else if (i == 10) {
            if (this.lastByte != 13) {
                this.out.write(newline);
            }
        } else {
            this.out.write(i);
        }
        this.lastByte = i;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        for (int i = off; i != off + len; ++i) {
            this.write(buf[i]);
        }
    }

    public void writeln(String s) throws IOException {
        byte[] bytes = s.getBytes(this.charset);
        this.write(bytes);
        this.write(newline);
    }

    public void writeln() throws IOException {
        this.write(newline);
    }

    static {
        CanonicalOutputStream.newline[0] = 13;
        CanonicalOutputStream.newline[1] = 10;
    }
}

