/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IPatchExecutable;
import java.util.Map;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirPatch {
    private final IGenericClient client;

    public FhirPatch(IGenericClient client) {
        this.client = client;
    }

    public MethodOutcome patchByUrl(String patchBody, String url, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IPatchExecutable patchExecutable = this.client.patch().withBody(patchBody).conditionalByUrl(url);
        if (preferReturn != null) {
            patchExecutable.prefer(preferReturn);
        }
        ExtraParameters.process(extraParameters, patchExecutable);
        return (MethodOutcome)patchExecutable.execute();
    }

    public MethodOutcome patchById(String patchBody, IIdType id, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IPatchExecutable patchExecutable = this.client.patch().withBody(patchBody).withId(id);
        if (preferReturn != null) {
            patchExecutable.prefer(preferReturn);
        }
        ExtraParameters.process(extraParameters, patchExecutable);
        return (MethodOutcome)patchExecutable.execute();
    }

    public MethodOutcome patchById(String patchBody, String stringId, PreferReturnEnum preferReturn, Map<ExtraParameters, Object> extraParameters) {
        IPatchExecutable patchExecutable = this.client.patch().withBody(patchBody).withId(stringId);
        if (preferReturn != null) {
            patchExecutable.prefer(preferReturn);
        }
        ExtraParameters.process(extraParameters, patchExecutable);
        return (MethodOutcome)patchExecutable.execute();
    }
}

