/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.EcsClientBuilder;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ecs", title="AWS 2 Elastic Container Service (ECS)", syntax="aws2-ecs:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class ECS2Endpoint
extends ScheduledPollEndpoint {
    private EcsClient ecsClient;
    @UriParam
    private ECS2Configuration configuration;

    public ECS2Endpoint(String uri, Component component, ECS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new ECS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ecsClient = this.configuration.getEcsClient() != null ? this.configuration.getEcsClient() : this.createECSClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getEcsClient()) && this.ecsClient != null) {
            this.ecsClient.close();
        }
        super.doStop();
    }

    public ECS2Configuration getConfiguration() {
        return this.configuration;
    }

    public EcsClient getEcsClient() {
        return this.ecsClient;
    }

    EcsClient createECSClient() {
        EcsClient client = null;
        EcsClientBuilder clientBuilder = EcsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (EcsClientBuilder)((EcsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (EcsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (EcsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (EcsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (EcsClient)clientBuilder.build();
        return client;
    }
}

