/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.mongodb.MongoDbChangeStreamsThread;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.bson.BsonDocument;

public class MongoDbChangeStreamsConsumer
extends DefaultConsumer {
    private static final String STREAM_FILTER_PROPERTY = "streamFilter";
    private final MongoDbEndpoint endpoint;
    private ExecutorService executor;
    private MongoDbChangeStreamsThread changeStreamsThread;

    public MongoDbChangeStreamsConsumer(MongoDbEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.changeStreamsThread != null) {
            this.changeStreamsThread.stop();
        }
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        String streamFilter = (String)this.getRoute().getProperties().get(STREAM_FILTER_PROPERTY);
        List<BsonDocument> bsonFilter = null;
        if (ObjectHelper.isNotEmpty((Object)streamFilter)) {
            bsonFilter = Collections.singletonList(BsonDocument.parse((String)streamFilter));
        }
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        this.changeStreamsThread = new MongoDbChangeStreamsThread(this.endpoint, this, bsonFilter);
        this.changeStreamsThread.init();
        this.executor.execute(this.changeStreamsThread);
    }
}

