/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import org.apache.camel.Exchange;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.component.as2.internal.AS2PropertiesHelper;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.AbstractApiProducer;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpCoreContext;

public class AS2Producer
extends AbstractApiProducer<AS2ApiName, AS2Configuration> {
    public AS2Producer(AS2Endpoint endpoint) {
        super((AbstractApiEndpoint)endpoint, (ApiMethodPropertiesHelper)AS2PropertiesHelper.getHelper());
    }

    public void interceptResult(Object methodResult, Exchange resultExchange) {
        HttpCoreContext context = (HttpCoreContext)methodResult;
        resultExchange.setProperty("CamelAS2.interchange", (Object)context);
        HttpResponse response = context.getResponse();
        HttpEntity entity = response.getEntity();
        if (entity instanceof DispositionNotificationMultipartReportEntity || entity instanceof MultipartSignedEntity) {
            resultExchange.getOut().setBody((Object)entity);
        } else {
            resultExchange.getOut().setBody(null);
        }
    }
}

