/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class UpdateTableCommand
extends AbstractDdbCommand {
    public UpdateTableCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        this.ddbClient.updateTable(new UpdateTableRequest().withTableName(this.determineTableName()).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(this.determineReadCapacity()).withWriteCapacityUnits(this.determineWriteCapacity())));
    }

    private Long determineReadCapacity() {
        Long readCapacity = (Long)this.exchange.getIn().getHeader("CamelAwsDdbReadCapacity", Long.class);
        return readCapacity != null ? readCapacity : this.configuration.getReadCapacity();
    }

    private Long determineWriteCapacity() {
        Long writeCapacity = (Long)this.exchange.getIn().getHeader("CamelAwsDdbWriteCapacity", Long.class);
        return writeCapacity != null ? writeCapacity : this.configuration.getWriteCapacity();
    }
}

