/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.ddb.DdbComponent;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class DdbComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DdbConfiguration getOrCreateConfiguration(DdbComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DdbConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DdbComponent target = (DdbComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonddbclient": 
            case "amazonDDBClient": {
                this.getOrCreateConfiguration(target).setAmazonDDBClient((AmazonDynamoDB)DdbComponentConfigurer.property((CamelContext)camelContext, AmazonDynamoDB.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)DdbComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((DdbConfiguration)DdbComponentConfigurer.property((CamelContext)camelContext, DdbConfiguration.class, (Object)value));
                return true;
            }
            case "consistentread": 
            case "consistentRead": {
                this.getOrCreateConfiguration(target).setConsistentRead((Boolean)DdbComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyattributename": 
            case "keyAttributeName": {
                this.getOrCreateConfiguration(target).setKeyAttributeName((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keyattributetype": 
            case "keyAttributeType": {
                this.getOrCreateConfiguration(target).setKeyAttributeType((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)DdbComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((DdbOperations)((Object)DdbComponentConfigurer.property((CamelContext)camelContext, DdbOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)DdbComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)DdbComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "readcapacity": 
            case "readCapacity": {
                this.getOrCreateConfiguration(target).setReadCapacity((Long)DdbComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)DdbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "writecapacity": 
            case "writeCapacity": {
                this.getOrCreateConfiguration(target).setWriteCapacity((Long)DdbComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonDDBClient", AmazonDynamoDB.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", DdbConfiguration.class);
        answer.put("consistentRead", Boolean.TYPE);
        answer.put("keyAttributeName", String.class);
        answer.put("keyAttributeType", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", DdbOperations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("readCapacity", Long.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("writeCapacity", Long.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DdbComponent target = (DdbComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonddbclient": 
            case "amazonDDBClient": {
                return this.getOrCreateConfiguration(target).getAmazonDDBClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consistentread": 
            case "consistentRead": {
                return this.getOrCreateConfiguration(target).isConsistentRead();
            }
            case "keyattributename": 
            case "keyAttributeName": {
                return this.getOrCreateConfiguration(target).getKeyAttributeName();
            }
            case "keyattributetype": 
            case "keyAttributeType": {
                return this.getOrCreateConfiguration(target).getKeyAttributeType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "readcapacity": 
            case "readCapacity": {
                return this.getOrCreateConfiguration(target).getReadCapacity();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "writecapacity": 
            case "writeCapacity": {
                return this.getOrCreateConfiguration(target).getWriteCapacity();
            }
        }
        return null;
    }
}

