/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.any23.utils;

import java.io.OutputStream;
import org.apache.any23.writer.JSONLDWriter;
import org.apache.any23.writer.NQuadsWriter;
import org.apache.any23.writer.NTriplesWriter;
import org.apache.any23.writer.RDFXMLWriter;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TurtleWriter;
import org.apache.camel.dataformat.any23.Any23OutputFormat;
import org.apache.camel.dataformat.any23.writer.RDF4JModelWriter;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;

public final class Any23Utils {
    private Any23Utils() {
    }

    public static TripleHandler obtainHandler(Any23OutputFormat format, OutputStream outputStream) {
        Object handler;
        switch (format) {
            case NTRIPLES: {
                handler = new NTriplesWriter(outputStream);
                break;
            }
            case TURTLE: {
                handler = new TurtleWriter(outputStream);
                break;
            }
            case NQUADS: {
                handler = new NQuadsWriter(outputStream);
                break;
            }
            case RDFXML: {
                handler = new RDFXMLWriter(outputStream);
                break;
            }
            case JSONLD: {
                handler = new JSONLDWriter(outputStream);
                break;
            }
            case RDFJSON: {
                handler = new JSONLDWriter(outputStream);
                break;
            }
            case RDF4JMODEL: {
                handler = new RDF4JModelWriter((Model)new LinkedHashModel());
                break;
            }
            default: {
                throw new AssertionError((Object)format.name());
            }
        }
        return handler;
    }
}

