/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelNodeDetailsFactory;
import org.apache.camel.tooling.model.JsonMapper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlTreeParserHelper {
    private final CamelCatalog camelCatalog = new DefaultCamelCatalog(true);

    public List<CamelNodeDetails> parseCamelRouteTree(Node xmlNode, String routeId, CamelNodeDetails route, String baseDir, String fullyQualifiedFileName) {
        CamelNodeDetailsFactory nodeFactory = CamelNodeDetailsFactory.newInstance();
        ArrayList<CamelNodeDetails> answer = new ArrayList<CamelNodeDetails>();
        this.walkXmlTree(nodeFactory, xmlNode, route);
        nodeFactory = CamelNodeDetailsFactory.newInstance();
        CamelNodeDetails parent = route.getOutputs().get(0);
        for (int i = 0; i < route.getOutputs().size(); ++i) {
            CamelNodeDetails node = route.getOutputs().get(i);
            String name = node.getName();
            if ("from".equals(name)) {
                CamelNodeDetails from = nodeFactory.copyNode(null, "from", node);
                from.setFileName(fullyQualifiedFileName);
                answer.add(from);
                parent = from;
                continue;
            }
            parent.addOutput(node);
            node.setFileName(fullyQualifiedFileName);
        }
        return answer;
    }

    private void walkXmlTree(CamelNodeDetailsFactory nodeFactory, Node node, CamelNodeDetails parent) {
        boolean isWhenOrOtherwise;
        CamelNodeDetails newNode = null;
        String name = node.getNodeName();
        boolean isRoute = "route".equals(name) || "from".equals(name);
        boolean isEip = this.camelCatalog.findModelNames().contains(name) && (this.hasInput(name) || this.hasOutput(name));
        boolean bl = isWhenOrOtherwise = "when".equals(name) || "otherwise".equals(name);
        if ((isRoute || isEip) && !"route".equals(name) && !isWhenOrOtherwise) {
            String lineNumber = (String)node.getUserData("lineNumber");
            String lineNumberEnd = (String)node.getUserData("lineNumberEnd");
            newNode = nodeFactory.newNode(parent, name);
            newNode.setRouteId(parent.getRouteId());
            newNode.setFileName(parent.getFileName());
            newNode.setLineNumber(lineNumber);
            newNode.setLineNumberEnd(lineNumberEnd);
            parent.addOutput(newNode);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.walkXmlTree(nodeFactory, child, newNode != null ? newNode : parent);
        }
    }

    private boolean hasOutput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isOutput();
    }

    private boolean hasInput(String name) {
        String json = this.camelCatalog.modelJSonSchema(name);
        return JsonMapper.generateEipModel((String)json).isInput();
    }
}

