/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.parser.helper.CamelXmlHelper;
import org.apache.camel.parser.helper.CamelXmlTreeParserHelper;
import org.apache.camel.parser.helper.XmlLineNumberParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelNodeDetailsFactory;
import org.apache.camel.parser.model.CamelRouteDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.camel.tooling.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XmlRouteParser {
    private XmlRouteParser() {
    }

    public static List<CamelNodeDetails> parseXmlRouteTree(InputStream xml, String baseDir, String fullyQualifiedFileName) {
        ArrayList<CamelNodeDetails> answer = new ArrayList<CamelNodeDetails>();
        Document dom = null;
        try {
            dom = XmlLineNumberParser.parseXml(xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dom != null) {
            CamelNodeDetailsFactory nodeFactory = CamelNodeDetailsFactory.newInstance();
            CamelXmlTreeParserHelper parser = new CamelXmlTreeParserHelper();
            List<Node> routes = CamelXmlHelper.findAllRoutes(dom);
            for (Node route : routes) {
                String routeId = CamelXmlHelper.getSafeAttribute(route, "id");
                String lineNumber = (String)route.getUserData("lineNumber");
                String lineNumberEnd = (String)route.getUserData("lineNumberEnd");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelNodeDetails node = nodeFactory.newNode(null, "route");
                node.setRouteId(routeId);
                node.setFileName(fileName);
                node.setLineNumber(lineNumber);
                node.setLineNumberEnd(lineNumberEnd);
                String column = (String)route.getUserData("colNumber");
                if (column != null) {
                    node.setLinePosition(Integer.valueOf(column));
                }
                List<CamelNodeDetails> tree = parser.parseCamelRouteTree(route, routeId, node, baseDir, fullyQualifiedFileName);
                answer.addAll(tree);
            }
        }
        return answer;
    }

    public static void parseXmlRouteEndpoints(InputStream xml, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints) throws Exception {
        Document dom = null;
        try {
            dom = XmlLineNumberParser.parseXml(xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dom != null) {
            List<Node> nodes = CamelXmlHelper.findAllEndpoints(dom);
            for (Node node : nodes) {
                String uri = CamelXmlHelper.getSafeAttribute(node, "uri");
                if (uri != null) {
                    uri = XmlRouteParser.trimEndpointUri(uri);
                }
                if (Strings.isNullOrEmpty((String)uri)) continue;
                String id = CamelXmlHelper.getSafeAttribute(node, "id");
                String lineNumber = (String)node.getUserData("lineNumber");
                String lineNumberEnd = (String)node.getUserData("lineNumberEnd");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                boolean consumerOnly = false;
                boolean producerOnly = false;
                String nodeName = node.getNodeName();
                if ("from".equals(nodeName) || "pollEnrich".equals(nodeName)) {
                    consumerOnly = true;
                } else if ("to".equals(nodeName) || "enrich".equals(nodeName) || "wireTap".equals(nodeName)) {
                    producerOnly = true;
                }
                CamelEndpointDetails detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setLineNumber(lineNumber);
                detail.setLineNumberEnd(lineNumberEnd);
                String column = (String)node.getUserData("colNumber");
                if (column != null) {
                    detail.setLinePosition(Integer.valueOf(column));
                }
                detail.setEndpointInstance(id);
                detail.setEndpointUri(uri);
                detail.setEndpointComponentName(XmlRouteParser.endpointComponentName(uri));
                detail.setConsumerOnly(consumerOnly);
                detail.setProducerOnly(producerOnly);
                endpoints.add(detail);
            }
        }
    }

    public static void parseXmlRouteSimpleExpressions(InputStream xml, String baseDir, String fullyQualifiedFileName, List<CamelSimpleExpressionDetails> simpleExpressions) throws Exception {
        Document dom = null;
        try {
            dom = XmlLineNumberParser.parseXml(xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dom != null) {
            List<Node> nodes = CamelXmlHelper.findAllSimpleExpressions(dom);
            for (Node node : nodes) {
                String simple = node.getTextContent();
                String lineNumber = (String)node.getUserData("lineNumber");
                String lineNumberEnd = (String)node.getUserData("lineNumberEnd");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelSimpleExpressionDetails detail = new CamelSimpleExpressionDetails();
                detail.setFileName(fileName);
                detail.setLineNumber(lineNumber);
                detail.setLineNumberEnd(lineNumberEnd);
                detail.setSimple(simple);
                String column = (String)node.getUserData("colNumber");
                if (column != null) {
                    detail.setLinePosition(Integer.valueOf(column));
                }
                boolean asPredicate = XmlRouteParser.isSimplePredicate(node);
                detail.setPredicate(asPredicate);
                detail.setExpression(!asPredicate);
                simpleExpressions.add(detail);
            }
        }
    }

    public static void parseXmlRouteRouteIds(InputStream xml, String baseDir, String fullyQualifiedFileName, List<CamelRouteDetails> routes) throws Exception {
        Document dom = null;
        try {
            dom = XmlLineNumberParser.parseXml(xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dom != null) {
            List<Node> nodes = CamelXmlHelper.findAllRoutes(dom);
            for (Node node : nodes) {
                String id = CamelXmlHelper.getSafeAttribute(node, "id");
                String lineNumber = (String)node.getUserData("lineNumber");
                String lineNumberEnd = (String)node.getUserData("lineNumberEnd");
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelRouteDetails detail = new CamelRouteDetails();
                detail.setFileName(fileName);
                detail.setLineNumber(lineNumber);
                detail.setLineNumberEnd(lineNumberEnd);
                detail.setRouteId(id);
                routes.add(detail);
            }
        }
    }

    private static boolean isSimplePredicate(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        if (name.equals("completionPredicate") || name.equals("completion")) {
            return true;
        }
        if (name.equals("onWhen") || name.equals("when") || name.equals("handled") || name.equals("continued")) {
            return true;
        }
        if (name.equals("retryWhile") || name.equals("filter") || name.equals("validate")) {
            return true;
        }
        if (name.equals("loop")) {
            Node attr;
            String doWhile = null;
            if (parent.getAttributes() != null && (attr = parent.getAttributes().getNamedItem("doWhile")) != null) {
                doWhile = attr.getTextContent();
            }
            if ("true".equalsIgnoreCase(doWhile)) {
                return true;
            }
        }
        return false;
    }

    private static String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(58)) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }

    private static String trimEndpointUri(String uri) {
        uri = uri.trim();
        uri = uri.replaceAll("(\\s+)(\\&)", "$2");
        uri = uri.replaceAll("(\\&)(\\s+)", "$1");
        uri = uri.replaceAll("(\\?)(\\s+)", "$1");
        return uri;
    }
}

