/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisProcessorsCreator;

public abstract class AbstractRedisProcessorCreator
implements RedisProcessorsCreator {
    protected Map<Command, Processor> result = new HashMap<Command, Processor>();

    @Override
    public Map<Command, Processor> getRedisProcessors() {
        return this.result;
    }

    protected void bind(Command command, Processor processor) {
        this.result.put(command, processor);
    }

    private void setResult(Exchange exchange, Object result) {
        Message message;
        if (exchange.getPattern().isOutCapable()) {
            message = exchange.getOut();
            message.copyFrom(exchange.getIn());
        } else {
            message = exchange.getIn();
        }
        message.setBody(result);
    }

    protected Processor wrap(Function<Exchange, Object> supplier) {
        return exchange -> {
            Object result = supplier.apply(exchange);
            this.setResult(exchange, result);
        };
    }
}

