/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultMessage;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperMessage
extends DefaultMessage {
    public static final String ZOOKEEPER_NODE = "CamelZooKeeperNode";
    public static final String ZOOKEEPER_NODE_VERSION = "CamelZooKeeperVersion";
    public static final String ZOOKEEPER_ERROR_CODE = "CamelZooKeeperErrorCode";
    public static final String ZOOKEEPER_ACL = "CamelZookeeperAcl";
    public static final String ZOOKEEPER_CREATE_MODE = "CamelZookeeperCreateMode";
    public static final String ZOOKEEPER_STATISTICS = "CamelZookeeperStatistics";
    public static final String ZOOKEEPER_EVENT_TYPE = "CamelZookeeperEventType";
    public static final String ZOOKEEPER_OPERATION = "CamelZookeeperOperation";

    public ZooKeeperMessage(CamelContext camelContext) {
        super(camelContext);
    }

    public ZooKeeperMessage(CamelContext camelContext, String node, Stat statistics, WatchedEvent watchedEvent) {
        this(camelContext, node, statistics, Collections.emptyMap(), watchedEvent);
    }

    public ZooKeeperMessage(CamelContext camelContext, String node, Stat statistics, Map<String, Object> headers) {
        this(camelContext, node, statistics, headers, null);
    }

    public ZooKeeperMessage(CamelContext camelContext, String node, Stat statistics, Map<String, Object> headers, WatchedEvent watchedEvent) {
        super(camelContext);
        this.setHeaders(headers);
        this.setHeader(ZOOKEEPER_NODE, node);
        this.setHeader(ZOOKEEPER_STATISTICS, statistics);
        if (watchedEvent != null) {
            this.setHeader(ZOOKEEPER_EVENT_TYPE, watchedEvent.getType());
        }
    }

    public static Stat getStatistics(Message message) {
        Stat stats = null;
        if (message != null) {
            stats = (Stat)message.getHeader(ZOOKEEPER_STATISTICS, Stat.class);
        }
        return stats;
    }

    public static String getPath(Message message) {
        String path = null;
        if (message != null) {
            path = (String)message.getHeader(ZOOKEEPER_NODE, String.class);
        }
        return path;
    }

    public DefaultMessage newInstance() {
        return new ZooKeeperMessage(this.getCamelContext());
    }
}

