/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.soroushbot.component.ReconnectableEventSourceListener;
import org.apache.camel.component.soroushbot.component.SoroushBotEndpoint;
import org.apache.camel.component.soroushbot.models.SoroushAction;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.service.SoroushService;
import org.apache.camel.component.soroushbot.utils.StringUtils;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoroushBotAbstractConsumer
extends DefaultConsumer
implements ShutdownPrepared {
    private static final Logger LOG = LoggerFactory.getLogger(SoroushBotAbstractConsumer.class);
    SoroushBotEndpoint endpoint;
    ObjectMapper objectMapper = new ObjectMapper();
    boolean shutdown;
    long lastMessageReceived;
    private ReconnectableEventSourceListener connection;

    public SoroushBotAbstractConsumer(SoroushBotEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void doStart() {
        this.run();
    }

    protected final void handleExceptionThrownWhileCreatingOrProcessingExchange(Exchange exchange, SoroushMessage soroushMessage, Exception ex) {
        exchange.setProperty("OriginalMessage", (Object)soroushMessage);
        this.getExceptionHandler().handleException("message can not be processed due to :" + ex.getMessage(), exchange, (Throwable)ex);
    }

    protected abstract void sendExchange(Exchange var1) throws Exception;

    private void run() {
        this.lastMessageReceived = System.currentTimeMillis();
        Request request = new Request.Builder().url(SoroushService.get().generateUrl(this.endpoint.getAuthorizationToken(), SoroushAction.getMessage, null)).build();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)this.endpoint.getConnectionTimeout(), TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.connection = new ReconnectableEventSourceListener(client, request, this.endpoint.getMaxConnectionRetry()){

            @Override
            protected boolean onBeforeConnect() {
                int connectionRetry = this.getConnectionRetry();
                try {
                    SoroushBotAbstractConsumer.this.endpoint.waitBeforeRetry(connectionRetry);
                }
                catch (InterruptedException e) {
                    return false;
                }
                if (!SoroushBotAbstractConsumer.this.shutdown) {
                    if (connectionRetry == 0) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("connecting to getMessage from soroush");
                        }
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info("connection is closed. retrying for the " + StringUtils.ordinal(connectionRetry) + " time(s)... ");
                    }
                }
                return !SoroushBotAbstractConsumer.this.shutdown;
            }

            @Override
            public void onOpen(EventSource eventSource, Response response) {
                super.onOpen(eventSource, response);
                LOG.info("connection established");
            }

            @Override
            protected boolean handleClose(EventSource eventSource, boolean manuallyClosed) {
                if (!manuallyClosed) {
                    LOG.warn("connection got closed");
                } else {
                    LOG.debug("manually reconnecting to ensure we have live connection");
                }
                return true;
            }

            @Override
            protected boolean handleFailure(EventSource eventSource, boolean manuallyClosed, Throwable t, Response response) {
                if (!manuallyClosed) {
                    LOG.error("connection failed due to following error", t);
                } else {
                    LOG.debug("manually reconnecting to ensure we have live connection");
                }
                return true;
            }

            public void onEvent(EventSource eventSource, String id, String type, String data) {
                Exchange exchange = SoroushBotAbstractConsumer.this.endpoint.createExchange();
                try {
                    SoroushMessage soroushMessage = (SoroushMessage)SoroushBotAbstractConsumer.this.objectMapper.readValue(data, SoroushMessage.class);
                    try {
                        exchange.getIn().setBody((Object)soroushMessage);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("event data is: " + data);
                        }
                        if (SoroushBotAbstractConsumer.this.endpoint.isAutoDownload()) {
                            SoroushBotAbstractConsumer.this.endpoint.handleDownloadFiles(soroushMessage);
                        }
                        SoroushBotAbstractConsumer.this.sendExchange(exchange);
                    }
                    catch (Exception ex) {
                        SoroushBotAbstractConsumer.this.handleExceptionThrownWhileCreatingOrProcessingExchange(exchange, soroushMessage, ex);
                    }
                }
                catch (IOException ex) {
                    LOG.error("can not parse data due to following error", (Throwable)ex);
                }
            }

            @Override
            public void onFinishProcess() {
                LOG.info("max connection retry reached! we are closing the endpoint!");
            }
        };
        this.connection.connect();
        this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "health check").scheduleAtFixedRate(() -> {
            if (this.lastMessageReceived < System.currentTimeMillis() - this.endpoint.getReconnectIdleConnectionTimeout()) {
                this.connection.close();
            }
        }, 2000L, this.endpoint.getReconnectIdleConnectionTimeout(), TimeUnit.MILLISECONDS);
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        if (!suspendOnly) {
            this.shutdown = true;
            this.connection.close();
        }
    }
}

