/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import com.github.brainlag.nsq.ServerAddress;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.SSLContextParameters;

@UriParams
public class NsqConfiguration {
    @UriPath(description="The NSQ topic")
    @Metadata(required=true)
    private String topic;
    @UriParam(description="The hostnames of one or more nsqlookupd servers (consumer) or nsqd servers (producer)")
    private String servers;
    @UriParam(label="consumer", description="The NSQ channel")
    private String channel;
    @UriParam(label="consumer", defaultValue="10")
    private int poolSize = 10;
    @UriParam(label="consumer", defaultValue="4161", description="The NSQ lookup server port")
    private int lookupServerPort = 4160;
    @UriParam(label="producer", defaultValue="4150")
    private int port = 4150;
    @UriParam(label="consumer", defaultValue="5000", javaType="java.time.Duration", description="The lookup interval")
    private long lookupInterval = 5000L;
    @UriParam(label="consumer", defaultValue="-1", javaType="java.time.Duration", description="The requeue interval in milliseconds. A value of -1 is the server default")
    private long requeueInterval = -1L;
    @UriParam(label="consumer", defaultValue="true", description="Automatically finish the NSQ Message when it is retrieved from the queue and before the Exchange is processed")
    private Boolean autoFinish = true;
    @UriParam(label="consumer", defaultValue="-1", javaType="java.time.Duration", description="The NSQ consumer timeout period for messages retrieved from the queue. A value of -1 is the server default")
    private long messageTimeout = -1L;
    @UriParam(description="A String to identify the kind of client")
    private String userAgent;
    @UriParam(label="security")
    private boolean secure;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public Set<ServerAddress> getServerAddresses() {
        Set serverAddresses = Sets.newConcurrentHashSet();
        String[] addresses = this.servers.split(",");
        for (int i = 0; i < addresses.length; ++i) {
            int port;
            String host;
            String[] token = addresses[i].split(":");
            if (token.length == 2) {
                host = token[0];
                port = Integer.parseInt(token[1]);
            } else if (token.length == 1) {
                host = token[0];
                port = 0;
            } else {
                throw new IllegalArgumentException("Invalid address: " + addresses[i]);
            }
            serverAddresses.add(new ServerAddress(host, port));
        }
        return serverAddresses;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getLookupServerPort() {
        return this.lookupServerPort;
    }

    public void setLookupServerPort(int lookupServerPort) {
        this.lookupServerPort = lookupServerPort;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getLookupInterval() {
        return this.lookupInterval;
    }

    public void setLookupInterval(long lookupInterval) {
        this.lookupInterval = lookupInterval;
    }

    public long getRequeueInterval() {
        return this.requeueInterval;
    }

    public void setRequeueInterval(long requeueInterval) {
        this.requeueInterval = requeueInterval;
    }

    public Boolean getAutoFinish() {
        return this.autoFinish;
    }

    public void setAutoFinish(Boolean autoFinish) {
        this.autoFinish = autoFinish;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

